/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.compatibility.protobuf.ProtobufCompatibilityCheckerLibrary;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ProtobufCompatibilityChecker
implements CompatibilityChecker {
    public CompatibilityExecutionResult testCompatibility(CompatibilityLevel compatibilityLevel, List<ContentHandle> existingArtifacts, ContentHandle proposedArtifact) {
        Objects.requireNonNull(compatibilityLevel, "compatibilityLevel MUST NOT be null");
        Objects.requireNonNull(existingArtifacts, "existingArtifacts MUST NOT be null");
        Objects.requireNonNull(proposedArtifact, "proposedArtifact MUST NOT be null");
        if (existingArtifacts.isEmpty()) {
            return CompatibilityExecutionResult.compatible();
        }
        ProtobufFile fileBefore = new ProtobufFile(existingArtifacts.get(existingArtifacts.size() - 1).content());
        ProtobufFile fileAfter = new ProtobufFile(proposedArtifact.content());
        switch (compatibilityLevel) {
            case BACKWARD: {
                return this.testBackward(fileBefore, fileAfter);
            }
            case BACKWARD_TRANSITIVE: {
                return this.testBackwardTransitive(existingArtifacts, fileAfter);
            }
            case FORWARD: {
                return this.testForward(fileBefore, fileAfter);
            }
            case FORWARD_TRANSITIVE: {
                return this.testForwardTransitive(existingArtifacts, fileAfter);
            }
            case FULL: {
                return this.testFull(fileBefore, fileAfter);
            }
            case FULL_TRANSITIVE: {
                return this.testFullTransitive(existingArtifacts, fileAfter);
            }
        }
        return CompatibilityExecutionResult.compatible();
    }

    @NotNull
    private CompatibilityExecutionResult testFullTransitive(List<ContentHandle> existingSchemas, ProtobufFile fileAfter) {
        for (ContentHandle existing : existingSchemas) {
            ProtobufFile fileBefore = new ProtobufFile(existing.content());
            if (this.testFull(fileBefore, fileAfter).isCompatible()) continue;
            return CompatibilityExecutionResult.incompatible((String)"The new version of the protobuf artifact is not fully compatible.");
        }
        return CompatibilityExecutionResult.compatible();
    }

    @NotNull
    private CompatibilityExecutionResult testFull(ProtobufFile fileBefore, ProtobufFile fileAfter) {
        ProtobufCompatibilityCheckerLibrary backwardChecker = new ProtobufCompatibilityCheckerLibrary(fileBefore, fileAfter);
        ProtobufCompatibilityCheckerLibrary forwardChecker = new ProtobufCompatibilityCheckerLibrary(fileAfter, fileBefore);
        if (!backwardChecker.validate() && !forwardChecker.validate()) {
            return CompatibilityExecutionResult.incompatible((String)"The new version of the protobuf artifact is not fully compatible.");
        }
        return CompatibilityExecutionResult.compatible();
    }

    @NotNull
    private CompatibilityExecutionResult testForwardTransitive(List<ContentHandle> existingSchemas, ProtobufFile fileAfter) {
        for (ContentHandle existing : existingSchemas) {
            ProtobufFile fileBefore = new ProtobufFile(existing.content());
            ProtobufCompatibilityCheckerLibrary checker = new ProtobufCompatibilityCheckerLibrary(fileAfter, fileBefore);
            if (checker.validate()) continue;
            return CompatibilityExecutionResult.incompatible((String)"The new version of the protobuf artifact is not forward compatible.");
        }
        return CompatibilityExecutionResult.compatible();
    }

    @NotNull
    private CompatibilityExecutionResult testForward(ProtobufFile fileBefore, ProtobufFile fileAfter) {
        ProtobufCompatibilityCheckerLibrary checker = new ProtobufCompatibilityCheckerLibrary(fileAfter, fileBefore);
        if (checker.validate()) {
            return CompatibilityExecutionResult.compatible();
        }
        return CompatibilityExecutionResult.incompatible((String)"The new version of the protobuf artifact is not forward compatible.");
    }

    @NotNull
    private CompatibilityExecutionResult testBackwardTransitive(List<ContentHandle> existingSchemas, ProtobufFile fileAfter) {
        for (ContentHandle existing : existingSchemas) {
            ProtobufFile fileBefore = new ProtobufFile(existing.content());
            ProtobufCompatibilityCheckerLibrary checker = new ProtobufCompatibilityCheckerLibrary(fileBefore, fileAfter);
            if (checker.validate()) continue;
            return CompatibilityExecutionResult.incompatible((String)"The new version of the protobuf artifact is not backward compatible.");
        }
        return CompatibilityExecutionResult.compatible();
    }

    @NotNull
    private CompatibilityExecutionResult testBackward(ProtobufFile fileBefore, ProtobufFile fileAfter) {
        ProtobufCompatibilityCheckerLibrary checker = new ProtobufCompatibilityCheckerLibrary(fileBefore, fileAfter);
        if (checker.validate()) {
            return CompatibilityExecutionResult.compatible();
        }
        return CompatibilityExecutionResult.incompatible((String)"The new version of the protobuf artifact is not backward compatible.");
    }
}

