/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.openmetrics.types;

import com.google.common.collect.ImmutableMap;
import io.airlift.openmetrics.types.Metric;
import io.airlift.stats.TimeDistribution;
import java.util.Map;
import java.util.Objects;

public record Summary(String metricName, Long count, Double sum, Double created, Map<Double, Double> quantiles, String help) implements Metric
{
    public Summary(String metricName, Long count, Double sum, Double created, Map<Double, Double> quantiles, String help) {
        this.metricName = Objects.requireNonNull(metricName, "metricName is null");
        this.count = count;
        this.sum = sum;
        this.created = created;
        this.quantiles = quantiles;
        this.help = help;
    }

    public static Summary from(String metricName, TimeDistribution timeDistribution, String help) {
        return new Summary(metricName, (long)timeDistribution.getCount(), timeDistribution.getAvg() * timeDistribution.getCount(), null, (Map<Double, Double>)ImmutableMap.builder().put((Object)0.5, (Object)timeDistribution.getP50()).put((Object)0.75, (Object)timeDistribution.getP75()).put((Object)0.9, (Object)timeDistribution.getP90()).put((Object)0.95, (Object)timeDistribution.getP95()).put((Object)0.99, (Object)timeDistribution.getP99()).build(), help);
    }

    @Override
    public String getMetricExposition() {
        StringBuilder stringBuilder = new StringBuilder("# TYPE %s %s\n".formatted(this.metricName, "summary"));
        if (this.help != null && !this.help.isEmpty()) {
            stringBuilder.append("# HELP %s %s\n".formatted(this.metricName, this.help));
        }
        if (this.count != null) {
            stringBuilder.append("%s %s\n".formatted(this.metricName + "_count", this.count));
        }
        if (this.sum != null) {
            stringBuilder.append("%s %s\n".formatted(this.metricName + "_sum", this.sum));
        }
        if (this.created != null) {
            stringBuilder.append("%s %s\n".formatted(this.metricName + "_created", this.created));
        }
        if (this.quantiles != null) {
            for (Map.Entry<Double, Double> quantile : this.quantiles.entrySet()) {
                stringBuilder.append("%s %s\n".formatted(this.metricName + "{quantile=\"%s\"}".formatted(quantile.getKey()), quantile.getValue()));
            }
        }
        return stringBuilder.toString();
    }
}

