/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.openmetrics.types;

import io.airlift.openmetrics.types.Metric;
import io.airlift.stats.CounterStat;
import java.util.Objects;

public record Counter(String metricName, long value, String help) implements Metric
{
    public Counter(String metricName, long value, String help) {
        this.metricName = Objects.requireNonNull(metricName, "metricName is null");
        this.value = value;
        this.help = help;
    }

    public static Counter from(String metricName, CounterStat counterStat, String help) {
        return new Counter(metricName, counterStat.getTotalCount(), help);
    }

    @Override
    public String getMetricExposition() {
        return Metric.formatSingleValuedMetric(this.metricName, "counter", this.help, Long.toString(this.value));
    }
}

