/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.openmetrics;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MetricsConfig {
    private List<ObjectName> jmxObjectNames = ImmutableList.of();

    public List<ObjectName> getJmxObjectNames() {
        return this.jmxObjectNames;
    }

    @Config(value="openmetrics.jmx-object-names")
    @ConfigDescription(value="JMX object names to include when retrieving all metrics.")
    public MetricsConfig setJmxObjectNames(List<String> jmxObjectNames) {
        ImmutableList.Builder objectNames = ImmutableList.builder();
        for (String jmxObjectName : jmxObjectNames) {
            try {
                objectNames.add((Object)new ObjectName(jmxObjectName));
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        }
        this.jmxObjectNames = objectNames.build();
        return this;
    }
}

