/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.idl.generator;

import com.google.common.collect.ImmutableMap;
import io.airlift.drift.codec.metadata.ThriftType;
import java.util.Map;

public class ThriftTypeRenderer {
    private final Map<ThriftType, String> typeNames;

    public ThriftTypeRenderer(Map<ThriftType, String> typeNames) {
        this.typeNames = ImmutableMap.copyOf(typeNames);
    }

    public String toString(ThriftType type) {
        switch (type.getProtocolType()) {
            case BOOL: {
                return "bool";
            }
            case BYTE: {
                return "byte";
            }
            case DOUBLE: {
                return "double";
            }
            case I16: {
                return "i16";
            }
            case I32: {
                return "i32";
            }
            case I64: {
                return "i64";
            }
            case ENUM: {
                return this.prefix(type) + type.getEnumMetadata().getEnumName();
            }
            case MAP: {
                return String.format("map<%s, %s>", this.toString(type.getKeyTypeReference().get()), this.toString(type.getValueTypeReference().get()));
            }
            case SET: {
                return String.format("set<%s>", this.toString(type.getValueTypeReference().get()));
            }
            case LIST: {
                return String.format("list<%s>", this.toString(type.getValueTypeReference().get()));
            }
            case STRUCT: {
                return type.equals((Object)ThriftType.VOID) ? "void" : this.prefix(type) + type.getStructMetadata().getStructName();
            }
            case STRING: {
                return "string";
            }
            case BINARY: {
                return "binary";
            }
        }
        throw new IllegalStateException("Bad protocol type: " + String.valueOf(type.getProtocolType()));
    }

    private String prefix(ThriftType type) {
        String result = this.typeNames.get(type);
        return result == null ? "" : result + ".";
    }
}

