/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.java.guice.ModuleInstantiator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.inject.Singleton;

public class GuiceFactory
implements ObjectFactory {
    private final List<Module> modules;
    private final Set<Class<?>> classes = new HashSet();
    private Injector injector;

    public GuiceFactory() throws IOException {
        this(GuiceFactory.loadCucumberGuiceProperties());
    }

    GuiceFactory(Properties properties) throws IOException {
        String guiceModuleClassName = properties.getProperty("guiceModule");
        this.modules = guiceModuleClassName == null ? Collections.emptyList() : new ModuleInstantiator().instantiate(guiceModuleClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadCucumberGuiceProperties() throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = GuiceFactory.class.getResourceAsStream("/cucumber-guice.properties");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return properties;
    }

    public void addClass(Class<?> clazz) {
        this.classes.add(clazz);
    }

    public void start() {
        this.injector = Guice.createInjector((Module[])new Module[]{new CucumberModule(this.classes, this.modules)});
    }

    public void stop() {
        this.injector = null;
    }

    public <T> T getInstance(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    private static final class CucumberModule
    extends AbstractModule {
        private final Set<Class<?>> classes;
        private final List<Module> modules;

        private CucumberModule(Set<Class<?>> classes, List<Module> modules) {
            this.classes = classes;
            this.modules = modules;
        }

        protected void configure() {
            for (Class<?> aClass : this.classes) {
                this.bind(aClass).in(Singleton.class);
            }
            for (Module module : this.modules) {
                this.install(module);
            }
        }
    }
}

