/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.runtime.ParameterInfo;
import cucumber.runtime.xstream.ConverterWithFormat;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

abstract class TimeConverter<T>
extends ConverterWithFormat<T> {
    private final List<DateFormat> formats = new ArrayList<DateFormat>();
    private SimpleDateFormat onlyFormat;

    TimeConverter(Locale locale, Class[] convertibleTypes) {
        super(convertibleTypes);
        this.addFormat(3, locale);
        this.addFormat(2, locale);
        this.addFormat(1, locale);
        this.addFormat(0, locale);
    }

    void addFormat(int style, Locale locale) {
        this.add(DateFormat.getDateInstance(style, locale));
    }

    void add(DateFormat dateFormat) {
        dateFormat.setLenient(false);
        this.formats.add(dateFormat);
    }

    @Override
    public List<? extends Format> getFormats() {
        return this.onlyFormat == null ? this.formats : Arrays.asList(this.onlyFormat);
    }

    @Override
    public String toString(Object obj) {
        if (obj instanceof Calendar) {
            obj = ((Calendar)obj).getTime();
        }
        return super.toString(obj);
    }

    @Override
    public void setParameterInfoAndLocale(ParameterInfo parameterInfo, Locale locale) {
        super.setParameterInfoAndLocale(parameterInfo, locale);
        if (parameterInfo.getFormat() != null) {
            this.onlyFormat = new SimpleDateFormat(parameterInfo.getFormat(), locale);
            this.onlyFormat.setLenient(false);
        }
    }

    public void removeOnlyFormat() {
        this.onlyFormat = null;
    }

    public static List<Class> getTimeClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Date.class);
        classes.add(Calendar.class);
        return classes;
    }
}

