/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Scenario;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ScenarioImpl
implements Scenario {
    private static final List<String> SEVERITY = Arrays.asList("passed", "skipped", "undefined", "pending", "failed");
    private final List<Result> stepResults = new ArrayList<Result>();
    private final Reporter reporter;
    private final Set<Tag> tags;

    public ScenarioImpl(Reporter reporter, Set<Tag> tags) {
        this.reporter = reporter;
        this.tags = tags;
    }

    void add(Result result) {
        this.stepResults.add(result);
    }

    @Override
    public Collection<String> getSourceTagNames() {
        HashSet<String> result = new HashSet<String>();
        for (Tag tag : this.tags) {
            result.add(tag.getName());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public String getStatus() {
        int pos = 0;
        for (Result stepResult : this.stepResults) {
            pos = Math.max(pos, SEVERITY.indexOf(stepResult.getStatus()));
        }
        return SEVERITY.get(pos);
    }

    @Override
    public boolean isFailed() {
        return "failed".equals(this.getStatus());
    }

    @Override
    public void embed(byte[] data, String mimeType) {
        this.reporter.embedding(mimeType, data);
    }

    @Override
    public void write(String text) {
        this.reporter.write(text);
    }
}

