/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.fhir.npm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXB;
import org.cqframework.fhir.npm.ILibraryReader;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class NpmModelInfoProvider
implements ModelInfoProvider {
    private List<NpmPackage> packages;
    private ILibraryReader reader;
    private IWorkerContext.ILoggingService logger;

    public NpmModelInfoProvider(List<NpmPackage> packages, ILibraryReader reader, IWorkerContext.ILoggingService logger) {
        this.packages = packages;
        this.reader = reader;
        this.logger = logger;
    }

    public ModelInfo load(ModelIdentifier modelIdentifier) {
        for (NpmPackage p : this.packages) {
            try {
                InputStream s;
                ModelIdentifier identifier = new ModelIdentifier().withId(modelIdentifier.getId()).withVersion(modelIdentifier.getVersion()).withSystem(modelIdentifier.getSystem());
                if (identifier.getSystem() == null) {
                    identifier.setSystem(p.canonical());
                }
                if ((s = p.loadByCanonicalVersion(identifier.getSystem() + "/Library/" + identifier.getId() + "-ModelInfo", identifier.getVersion())) == null) continue;
                Library l = this.reader.readLibrary(s);
                for (Attachment a : l.getContent()) {
                    if (a.getContentType() == null || !a.getContentType().equals("application/xml")) continue;
                    if (modelIdentifier.getSystem() == null) {
                        modelIdentifier.setSystem(identifier.getSystem());
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(a.getData());
                    return (ModelInfo)JAXB.unmarshal((InputStream)is, ModelInfo.class);
                }
            }
            catch (IOException e) {
                this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.PROGRESS, String.format("Exceptions occurred attempting to load npm library for model %s", modelIdentifier.toString()));
            }
        }
        return null;
    }
}

