/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.util;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.AbstractWeighted;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.WeightedValue;
import java.util.Comparator;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2007-11-25", changesNeeded=false, comments={"Looks fine."})
public class DefaultWeightedValue<ValueType>
extends AbstractWeighted
implements WeightedValue<ValueType> {
    protected ValueType value;

    public DefaultWeightedValue() {
        this((Object)null);
    }

    public DefaultWeightedValue(ValueType value) {
        this(value, 1.0);
    }

    public DefaultWeightedValue(ValueType value, double weight) {
        super(weight);
        this.setValue(value);
    }

    public DefaultWeightedValue(WeightedValue<? extends ValueType> other) {
        this(other.getValue(), other.getWeight());
    }

    @Override
    public DefaultWeightedValue<ValueType> clone() {
        DefaultWeightedValue clone = (DefaultWeightedValue)super.clone();
        clone.setValue(ObjectUtil.cloneSmart(this.getValue()));
        return clone;
    }

    @Override
    public ValueType getValue() {
        return this.value;
    }

    public void setValue(ValueType value) {
        this.value = value;
    }

    public static <ValueType> DefaultWeightedValue<ValueType> create(ValueType value, double weight) {
        return new DefaultWeightedValue<ValueType>(value, weight);
    }

    public static class WeightComparator
    extends AbstractCloneableSerializable
    implements Comparator<WeightedValue<?>> {
        private static WeightComparator INSTANCE = null;

        public static WeightComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new WeightComparator();
            }
            return INSTANCE;
        }

        @Override
        public int compare(WeightedValue<?> first, WeightedValue<?> second) {
            return Double.compare(first.getWeight(), second.getWeight());
        }
    }
}

