/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.util;

import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultTriple<FirstType, SecondType, ThirdType>
extends AbstractCloneableSerializable
implements Triple<FirstType, SecondType, ThirdType> {
    protected FirstType first;
    protected SecondType second;
    protected ThirdType third;

    public DefaultTriple() {
        this(null, null, null);
    }

    public DefaultTriple(FirstType first, SecondType second, ThirdType third) {
        this.setFirst(first);
        this.setSecond(second);
        this.setThird(third);
    }

    @Override
    public DefaultTriple<FirstType, SecondType, ThirdType> clone() {
        DefaultTriple result = (DefaultTriple)super.clone();
        result.first = ObjectUtil.cloneSmart(result.first);
        result.second = ObjectUtil.cloneSmart(result.second);
        result.third = ObjectUtil.cloneSmart(result.third);
        return result;
    }

    @Override
    public FirstType getFirst() {
        return this.first;
    }

    public void setFirst(FirstType first) {
        this.first = first;
    }

    @Override
    public SecondType getSecond() {
        return this.second;
    }

    public void setSecond(SecondType second) {
        this.second = second;
    }

    @Override
    public ThirdType getThird() {
        return this.third;
    }

    public void setThird(ThirdType third) {
        this.third = third;
    }

    public static <FirstType, SecondType, ThirdType> ArrayList<DefaultTriple<FirstType, SecondType, ThirdType>> mergeCollections(Collection<FirstType> firsts, Collection<SecondType> seconds, Collection<ThirdType> thirds) {
        int count = firsts.size();
        if (count != seconds.size() || count != thirds.size()) {
            throw new IllegalArgumentException("Collections are not the same size.");
        }
        ArrayList<DefaultTriple<FirstType, SecondType, ThirdType>> result = new ArrayList<DefaultTriple<FirstType, SecondType, ThirdType>>(count);
        Iterator<SecondType> i2 = seconds.iterator();
        Iterator<ThirdType> i3 = thirds.iterator();
        for (FirstType d1 : firsts) {
            result.add(new DefaultTriple<FirstType, SecondType, ThirdType>(d1, i2.next(), i3.next()));
        }
        return result;
    }
}

