/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.util;

public class ArgumentChecker {
    public static void assertIsNotNull(String argument, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(argument + " cannot be null.");
        }
    }

    public static void assertIsPositive(String argument, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException(argument + " must be positive " + "(was " + value + ").");
        }
    }

    public static void assertIsPositive(String argument, double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException(argument + " must be positive " + "(was " + value + ").");
        }
    }

    public static void assertIsNonNegative(String argument, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(argument + " cannot be negative " + "(was " + value + ").");
        }
    }

    public static void assertIsNonNegative(String argument, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException(argument + " cannot be negative " + "(was " + value + ").");
        }
    }

    public static void assertIsInRangeInclusive(String argument, double value, double lowerBound, double upperBound) {
        if (value < lowerBound || value > upperBound) {
            throw new IllegalArgumentException("" + argument + " must be between " + lowerBound + " and " + upperBound + " (was " + value + ").");
        }
    }

    public static void assertIsInRangeExclusive(String argument, double value, double lowerBound, double upperBound) {
        if (value <= lowerBound || value >= upperBound) {
            throw new IllegalArgumentException("" + argument + " must be between " + lowerBound + " and " + upperBound + " (was " + value + ").");
        }
    }
}

