/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.Vectorizable;
import java.text.NumberFormat;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-26", changesNeeded=false, comments={"Minor changes to formatting.", "Otherwise, looks good."}), @CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-17", changesNeeded=false, comments={"Looks fine."})})
public interface Vector
extends Ring<Vector>,
Iterable<VectorEntry>,
Vectorizable {
    @Override
    public Vector clone();

    public int getDimensionality();

    public double getElement(int var1);

    public void setElement(int var1, double var2);

    public double dotProduct(Vector var1);

    public Matrix outerProduct(Vector var1);

    public double angle(Vector var1);

    public double cosine(Vector var1);

    public double sum();

    public double norm1();

    public double norm2();

    public double norm2Squared();

    public double normInfinity();

    public double euclideanDistance(Vector var1);

    public double euclideanDistanceSquared(Vector var1);

    public Vector times(Matrix var1);

    public Vector unitVector();

    public void unitVectorEquals();

    public boolean checkSameDimensionality(Vector var1);

    public void assertSameDimensionality(Vector var1);

    public void assertDimensionalityEquals(int var1);

    public Vector stack(Vector var1);

    public Vector subVector(int var1, int var2);

    public String toString();

    public String toString(NumberFormat var1);

    public String toString(NumberFormat var1, String var2);

    public boolean isUnitVector();

    public boolean isUnitVector(double var1);
}

