/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.collection.NumberComparator;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class UnivariateSummaryStatistics
extends AbstractCloneableSerializable {
    public static final double CONFIDENCE_REGION = 0.95;
    private double min;
    private double max;
    private double[] quintiles;
    private double confidenceLower;
    private double confidenceUpper;
    private double median;
    private int numSamples;
    private double mean;
    private double variance;
    private double skewness;
    private double kurtosis;

    protected UnivariateSummaryStatistics(double min, double max, double[] quintiles, double confidenceLower, double confidenceUpper, double median, int numSamples, double mean, double variance, double skewness, double kurtosis) {
        this.min = min;
        this.max = max;
        this.quintiles = quintiles;
        this.confidenceLower = confidenceLower;
        this.confidenceUpper = confidenceUpper;
        this.median = median;
        this.numSamples = numSamples;
        this.mean = mean;
        this.variance = variance;
        this.skewness = skewness;
        this.kurtosis = kurtosis;
    }

    @Override
    public UnivariateSummaryStatistics clone() {
        UnivariateSummaryStatistics clone = (UnivariateSummaryStatistics)super.clone();
        return clone;
    }

    public static UnivariateSummaryStatistics create(Collection<? extends Number> data) {
        ArrayList<? extends Number> sortedData = CollectionUtil.asArrayList(data);
        Collections.sort(sortedData, NumberComparator.INSTANCE);
        Pair<Double, Double> result = UnivariateStatisticsUtil.computeMinAndMax(sortedData);
        double min = result.getFirst();
        double max = result.getSecond();
        double median = UnivariateStatisticsUtil.computeMedian(sortedData);
        double[] quintiles = new double[]{UnivariateStatisticsUtil.computePercentile(sortedData, 0.2), UnivariateStatisticsUtil.computePercentile(sortedData, 0.4), UnivariateStatisticsUtil.computePercentile(sortedData, 0.6), UnivariateStatisticsUtil.computePercentile(sortedData, 0.8)};
        double a2 = 0.025000000000000022;
        double confidenceLower = UnivariateStatisticsUtil.computePercentile(sortedData, a2);
        double confidenceUpper = UnivariateStatisticsUtil.computePercentile(sortedData, 1.0 - a2);
        int numSamples = data.size();
        result = UnivariateStatisticsUtil.computeMeanAndVariance(sortedData);
        double mean = result.getFirst();
        double variance = result.getSecond();
        double skewness = UnivariateStatisticsUtil.computeSkewness(sortedData);
        double kurtosis = UnivariateStatisticsUtil.computeKurtosis(sortedData);
        return new UnivariateSummaryStatistics(min, max, quintiles, confidenceLower, confidenceUpper, median, numSamples, mean, variance, skewness, kurtosis);
    }

    public String toString() {
        StringBuilder retval = new StringBuilder(1000);
        retval.append("Sample Count = ").append(this.getNumSamples());
        retval.append("\n");
        retval.append("20/80 Region = [").append(this.getQuintiles()[0]).append(", ").append(this.getQuintiles()[3]).append("]");
        retval.append("\n");
        retval.append("40/60 Region = [").append(this.getQuintiles()[1]).append(", ").append(this.getQuintiles()[2]).append("]");
        retval.append("\n");
        retval.append("95% Region   = [").append(this.getConfidenceLower()).append(", ").append(this.getConfidenceUpper()).append("]");
        retval.append("\n");
        retval.append("Min and Max  = [").append(this.getMin()).append(", ").append(this.getMax()).append("]");
        retval.append("\n");
        retval.append("Median   = ").append(this.getMedian());
        retval.append("\n");
        retval.append("Mean     = ").append(this.getMean()).append(", StdDev = ").append(Math.sqrt(this.getVariance()));
        retval.append("\n");
        retval.append("Skewness = ").append(this.getSkewness()).append(", Kurtosis = ").append(this.getKurtosis());
        retval.append("\n");
        return retval.toString();
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getSkewness() {
        return this.skewness;
    }

    public double getKurtosis() {
        return this.kurtosis;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double[] getQuintiles() {
        return this.quintiles;
    }

    public double getConfidenceLower() {
        return this.confidenceLower;
    }

    public double getConfidenceUpper() {
        return this.confidenceUpper;
    }
}

