/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.annotation.CodeReview;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-26", changesNeeded=false, comments={"Looks good."})
public class Permutation {
    public static <DataType> void reorder(ArrayList<DataType> list, Random random) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int randomIndex = i + random.nextInt(size - i);
            DataType elementRandom = list.get(randomIndex);
            DataType elementI = list.get(i);
            list.set(i, elementRandom);
            list.set(randomIndex, elementI);
        }
    }

    public static <DataType> ArrayList<DataType> createReordering(Collection<? extends DataType> collection, Random random) {
        ArrayList<? extends DataType> result = new ArrayList<DataType>(collection);
        Permutation.reorder(result, random);
        return result;
    }

    public static int[] createPermutation(int n, Random random) {
        int i;
        int[] result = new int[n];
        for (i = 0; i < n; ++i) {
            result[i] = i;
        }
        for (i = 0; i < n; ++i) {
            int randomIndex = i + random.nextInt(n - i);
            int temp = result[i];
            result[i] = result[randomIndex];
            result[randomIndex] = temp;
        }
        return result;
    }
}

