/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=false, comments={"Looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-04-25", changesNeeded=false, comments={"Only a few minor modifications were made to the documentation.", "Everything checks out."})})
public abstract class AbstractRing<RingType extends Ring<RingType>>
extends AbstractCloneableSerializable
implements Ring<RingType> {
    @Override
    public RingType clone() {
        return (RingType)((Ring)super.clone());
    }

    @Override
    public RingType dotTimes(RingType other) {
        CloneableSerializable copy = this.clone();
        copy.dotTimesEquals(other);
        return (RingType)copy;
    }

    @Override
    public RingType minus(RingType other) {
        CloneableSerializable copy = this.clone();
        copy.minusEquals(other);
        return (RingType)copy;
    }

    @Override
    public RingType plus(RingType other) {
        CloneableSerializable copy = this.clone();
        copy.plusEquals(other);
        return (RingType)copy;
    }

    @Override
    public RingType scale(double scaleFactor) {
        CloneableSerializable copy = this.clone();
        copy.scaleEquals(scaleFactor);
        return (RingType)copy;
    }

    @Override
    public RingType negative() {
        CloneableSerializable copy = this.clone();
        copy.negativeEquals();
        return (RingType)copy;
    }

    @Override
    public void negativeEquals() {
        this.scaleEquals(-1.0);
    }

    @Override
    public void zero() {
        this.scaleEquals(0.0);
    }

    @Override
    public boolean isZero() {
        return this.isZero(0.0);
    }
}

