/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.evaluator;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.evaluator.StatefulEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=false, comments={"Looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2007-11-20", changesNeeded=false, comments={"Cleaned up."})})
public abstract class AbstractStatefulEvaluator<InputType, OutputType, StateType extends CloneableSerializable>
extends AbstractCloneableSerializable
implements StatefulEvaluator<InputType, OutputType, StateType> {
    private StateType state;

    public AbstractStatefulEvaluator() {
        this(null);
    }

    public AbstractStatefulEvaluator(StateType initialState) {
        this.setState(initialState);
    }

    @Override
    public AbstractStatefulEvaluator<InputType, OutputType, StateType> clone() {
        AbstractStatefulEvaluator result = (AbstractStatefulEvaluator)super.clone();
        result.state = ObjectUtil.cloneSafe(this.state);
        return result;
    }

    @Override
    public OutputType evaluate(InputType input, StateType state) {
        this.setState(state);
        return this.evaluate(input);
    }

    @Override
    public StateType getState() {
        if (this.state == null) {
            this.setState(this.createDefaultState());
        }
        return this.state;
    }

    @Override
    public void setState(StateType state) {
        this.state = state;
    }

    @Override
    public void resetState() {
        this.setState(this.createDefaultState());
    }
}

