/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.index;

import fr.pilato.elasticsearch.tools.index.IndexSettingsReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;

public class IndexElasticsearchUpdater {
    private static final Logger logger = LogManager.getLogger(IndexElasticsearchUpdater.class);

    public static void createIndex(Client client, String root, String index, boolean force) throws Exception {
        String settings = IndexSettingsReader.readSettings(root, index);
        IndexElasticsearchUpdater.createIndexWithSettings(client, index, settings, force);
    }

    public static void createIndex(Client client, String index, boolean force) throws Exception {
        String settings = IndexSettingsReader.readSettings(index);
        IndexElasticsearchUpdater.createIndexWithSettings(client, index, settings, force);
    }

    public static void createIndexWithSettings(Client client, String index, String settings, boolean force) throws Exception {
        if (force && IndexElasticsearchUpdater.isIndexExist(client, index)) {
            logger.debug("Index [{}] already exists but force set to true. Removing all data!", new Object[]{index});
            IndexElasticsearchUpdater.removeIndexInElasticsearch(client, index);
        }
        if (force || !IndexElasticsearchUpdater.isIndexExist(client, index)) {
            logger.debug("Index [{}] doesn't exist. Creating it.", new Object[]{index});
            IndexElasticsearchUpdater.createIndexWithSettingsInElasticsearch(client, index, settings);
        } else {
            logger.debug("Index [{}] already exists.", new Object[]{index});
        }
    }

    private static void removeIndexInElasticsearch(Client client, String index) throws Exception {
        logger.trace("removeIndex([{}])", new Object[]{index});
        assert (client != null);
        assert (index != null);
        DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)client.admin().indices().prepareDelete(new String[]{index}).get();
        if (!deleteIndexResponse.isAcknowledged()) {
            logger.warn("Could not delete index [{}]", new Object[]{index});
            throw new Exception("Could not delete index [" + index + "].");
        }
        logger.trace("/removeIndex([{}])", new Object[]{index});
    }

    private static void createIndexWithSettingsInElasticsearch(Client client, String index, String settings) throws Exception {
        CreateIndexResponse createIndexResponse;
        logger.trace("createIndex([{}])", new Object[]{index});
        assert (client != null);
        assert (index != null);
        CreateIndexRequestBuilder cirb = client.admin().indices().prepareCreate(index);
        if (settings != null) {
            logger.trace("Found settings for index [{}]: [{}]", new Object[]{index, settings});
            cirb.setSettings(settings);
        }
        if (!(createIndexResponse = (CreateIndexResponse)cirb.execute().actionGet()).isAcknowledged()) {
            logger.warn("Could not create index [{}]", new Object[]{index});
            throw new Exception("Could not create index [" + index + "].");
        }
        logger.trace("/createIndex([{}])", new Object[]{index});
    }

    private static void updateIndexWithSettingsInElasticsearch(Client client, String index, String settings) throws Exception {
        logger.trace("updateIndex([{}])", new Object[]{index});
        assert (client != null);
        assert (index != null);
        if (settings != null) {
            logger.trace("Found update settings for index [{}]: [{}]", new Object[]{index, settings});
            logger.debug("updating settings for index [{}]", new Object[]{index});
            client.admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).get();
        }
        logger.trace("/updateIndex([{}])", new Object[]{index});
    }

    public static boolean isIndexExist(Client client, String index) throws Exception {
        return ((IndicesExistsResponse)client.admin().indices().prepareExists(new String[]{index}).get()).isExists();
    }

    public static void updateSettings(Client client, String root, String index) throws Exception {
        String settings = IndexSettingsReader.readUpdateSettings(root, index);
        IndexElasticsearchUpdater.updateIndexWithSettingsInElasticsearch(client, index, settings);
    }

    public static void updateSettings(Client client, String index) throws Exception {
        String settings = IndexSettingsReader.readUpdateSettings(index);
        IndexElasticsearchUpdater.updateIndexWithSettingsInElasticsearch(client, index, settings);
    }
}

