/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingsReader {
    private static final Logger logger = LogManager.getLogger(SettingsReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileFromClasspath(String file) {
        logger.trace("Reading file [{}]...", new Object[]{file});
        String content = null;
        try (InputStream asStream = SettingsReader.class.getClassLoader().getResourceAsStream(file);){
            if (asStream == null) {
                logger.trace("Can not find [{}] in class loader.", new Object[]{file});
                String string = null;
                return string;
            }
            content = IOUtils.toString((InputStream)asStream, (String)"UTF-8");
            return content;
        }
        catch (IOException e) {
            logger.warn("Can not read [{}].", new Object[]{file});
        }
        return content;
    }
}

