/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingsFinder {
    private static final Logger logger = LogManager.getLogger(SettingsFinder.class);

    public static String fromClasspath(String file) throws IOException {
        return file;
    }

    protected static ArrayList<String> findJsonFiles(Path root, String subdir) throws IOException {
        logger.debug("Looking for json files in classpath under [{}/{}].", new Object[]{root, subdir});
        final ArrayList<String> jsonFiles = new ArrayList<String>();
        final Path indexDir = root.resolve(subdir);
        if (Files.exists(indexDir, new LinkOption[0])) {
            Files.walkFileTree(indexDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String jsonFile = indexDir.relativize(file).toString();
                    if (jsonFile.equals(Defaults.IndexSettingsFileName) || jsonFile.equals(Defaults.UpdateIndexSettingsFileName)) {
                        logger.trace("ignoring: [{}]", new Object[]{jsonFile});
                        return FileVisitResult.CONTINUE;
                    }
                    jsonFile = jsonFile.substring(0, jsonFile.lastIndexOf(Defaults.JsonFileExtension));
                    jsonFiles.add(jsonFile);
                    logger.trace("json found: [{}]", new Object[]{jsonFile});
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            logger.trace("[{}] does not exist in [{}].", new Object[]{subdir, root});
        }
        return jsonFiles;
    }

    public static class Defaults {
        public static String ConfigDir = "elasticsearch";
        public static String JsonFileExtension = ".json";
        public static String IndexSettingsFileName = "_settings.json";
        public static String UpdateIndexSettingsFileName = "_update_settings.json";
        public static String TemplateDir = "_template";
    }
}

