/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools;

import fr.pilato.elasticsearch.tools.SettingsFinder;
import fr.pilato.elasticsearch.tools.index.IndexElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.index.IndexFinder;
import fr.pilato.elasticsearch.tools.template.TemplateElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.template.TemplateFinder;
import fr.pilato.elasticsearch.tools.type.TypeElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.type.TypeFinder;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;

public class ElasticsearchBeyonder {
    private static final Logger logger = LogManager.getLogger(ElasticsearchBeyonder.class);

    public static void start(Client client) throws Exception {
        ElasticsearchBeyonder.start(client, SettingsFinder.fromClasspath(SettingsFinder.Defaults.ConfigDir));
    }

    public static void start(Client client, String root) throws Exception {
        logger.info("starting automatic settings/mappings discovery");
        boolean merge = true;
        boolean force = false;
        List<String> templateNames = TemplateFinder.findTemplates(root);
        for (String templateName : templateNames) {
            TemplateElasticsearchUpdater.createTemplate(client, root, templateName, force);
        }
        List<String> indexNames = IndexFinder.findIndexNames(root);
        for (String indexName : indexNames) {
            IndexElasticsearchUpdater.createIndex(client, root, indexName, force);
            IndexElasticsearchUpdater.updateSettings(client, root, indexName);
            List<String> types = TypeFinder.findTypes(root, indexName);
            for (String typeName : types) {
                TypeElasticsearchUpdater.createMapping(client, root, indexName, typeName, merge);
            }
        }
        logger.info("start done. Rock & roll!");
    }
}

