/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter;

import fr.opensagres.xdocreport.converter.ConverterFrom;
import fr.opensagres.xdocreport.converter.ConverterTo;
import fr.opensagres.xdocreport.converter.IConverter;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.converter.discovery.IConverterDiscovery;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.registry.AbstractRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConverterRegistry
extends AbstractRegistry<IConverterDiscovery> {
    private static final ConverterRegistry INSTANCE = new ConverterRegistry();
    private static final Logger LOGGER = LogUtils.getLogger((String)ConverterRegistry.class.getName());
    private Map<String, ConverterFrom> converters = new HashMap<String, ConverterFrom>();

    public ConverterRegistry() {
        super(IConverterDiscovery.class);
    }

    public static ConverterRegistry getRegistry() {
        return INSTANCE;
    }

    public IConverter findConverter(Options options) throws XDocConverterException {
        return this.findConverter(options.getFrom(), options.getTo(), options.getVia());
    }

    public IConverter findConverter(String from, String to, String via) throws XDocConverterException {
        return this.internalFindConverter(from, to, via, true);
    }

    public IConverter getConverter(Options options) {
        return this.getConverter(options.getFrom(), options.getTo(), options.getVia());
    }

    public IConverter getConverter(String from, String to, String via) {
        try {
            return this.internalFindConverter(from, to, via, false);
        }
        catch (XDocConverterException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(e.getMessage());
            }
            return null;
        }
    }

    public ConverterFrom getConverterFrom(String from) {
        this.initializeIfNeeded();
        return this.converters.get(from);
    }

    public Set<String> getFroms() {
        this.initializeIfNeeded();
        return this.converters.keySet();
    }

    private IConverter internalFindConverter(String from, String to, String via, boolean throwError) throws XDocConverterException {
        this.initializeIfNeeded();
        ConverterFrom fromConverters = this.getConverterFrom(from);
        if (fromConverters == null) {
            if (throwError) {
                String msg = String.format("Cannot find converters from=%s", from);
                LOGGER.severe(msg);
                throw new XDocConverterException(msg);
            }
            return null;
        }
        ConverterTo toConverters = fromConverters.getConverterTo(to);
        if (toConverters == null) {
            if (throwError) {
                String msg = String.format("Cannot find converters for to=%s for from=%s", to, from);
                LOGGER.severe(msg);
                throw new XDocConverterException(msg);
            }
            return null;
        }
        if (via == null) {
            IConverter converter = toConverters.getFirstConverter();
            if (throwError && converter == null && throwError) {
                String msg = String.format("Cannot find converters for to=%s for from=%s", to, from);
                LOGGER.severe(msg);
                throw new XDocConverterException(msg);
            }
            return converter;
        }
        IConverter converter = toConverters.getConverter(via);
        if (converter == null && throwError) {
            String msg = String.format("Cannot find converters via %s for to=%s for from=%s", via, to, from);
            LOGGER.severe(msg);
            throw new XDocConverterException(msg);
        }
        return converter;
    }

    protected void doDispose() {
        this.converters.clear();
    }

    protected boolean registerInstance(IConverterDiscovery discovery) {
        String from = discovery.getFrom();
        String to = discovery.getTo();
        String via = discovery.getVia();
        IConverter converter = discovery.getConverter();
        ConverterFrom converterFrom = this.converters.get(from);
        if (converterFrom == null) {
            converterFrom = new ConverterFrom(from);
            this.converters.put(converterFrom.getFrom(), converterFrom);
        }
        converterFrom.addConverter(to, via, converter);
        return true;
    }
}

