/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.rewrite;

import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.SummarizeAsGroup;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Map;

public final class ProjectChangeset {
    private static final ProjectChangeset EMPTY = new ProjectChangeset();
    private final ImmutableList<ProjectChange> changes;
    private static Predicate<ProjectChange> summarizable = new Predicate<ProjectChange>(){

        public boolean apply(ProjectChange input) {
            return input instanceof SummarizeAsGroup;
        }
    };
    private static Function<ProjectChange, String> summarizableGroupName = new Function<ProjectChange, String>(){

        public String apply(ProjectChange input) {
            return input instanceof SummarizeAsGroup ? ((SummarizeAsGroup)((Object)input)).getGroupName() : "";
        }
    };
    private static Function<Map.Entry<String, Collection<ProjectChange>>, String> summaryDescription = new Function<Map.Entry<String, Collection<ProjectChange>>, String>(){

        public String apply(Map.Entry<String, Collection<ProjectChange>> input) {
            return input.getKey().equals("") ? null : input.getKey() + ": " + input.getValue().size();
        }
    };

    public static ProjectChangeset changeset() {
        return EMPTY;
    }

    public ProjectChangeset() {
        this((Iterable<ProjectChange>)ImmutableList.of());
    }

    private ProjectChangeset(Iterable<ProjectChange> changes) {
        this.changes = ImmutableList.copyOf(changes);
    }

    public Iterable<ProjectChange> getItems() {
        return this.changes;
    }

    public <T extends ProjectChange> Iterable<T> getItems(Class<T> itemClass) {
        return Iterables.filter(this.changes, itemClass);
    }

    public boolean hasItems(Class<? extends ProjectChange> itemClass) {
        return !Iterables.isEmpty(this.getItems(itemClass));
    }

    public ProjectChangeset with(ProjectChange ... newChanges) {
        return new ProjectChangeset(Iterables.concat(this.changes, (Iterable)ImmutableList.copyOf((Object[])newChanges)));
    }

    public ProjectChangeset with(Iterable<? extends ProjectChange> newChanges) {
        return new ProjectChangeset(Iterables.concat(this.changes, (Iterable)ImmutableList.copyOf(newChanges)));
    }

    public ProjectChangeset with(ProjectChangeset other) {
        return new ProjectChangeset(Iterables.concat(this.changes, other.changes));
    }

    public Iterable<String> getAllChangeDescriptions() {
        return Iterables.transform(this.changes, (Function)Functions.toStringFunction());
    }

    public Iterable<String> getChangeDescriptionsOrSummaries() {
        ImmutableSet uniqueDescriptions = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(this.changes, (Predicate)Predicates.not(summarizable)), (Function)Functions.toStringFunction()));
        ImmutableListMultimap summaries = Multimaps.index(this.changes, summarizableGroupName);
        return Iterables.concat((Iterable)Ordering.natural().sortedCopy((Iterable)uniqueDescriptions), (Iterable)Iterables.filter((Iterable)Iterables.transform(summaries.asMap().entrySet(), summaryDescription), (Predicate)Predicates.notNull()));
    }

    public String toString() {
        return Joiner.on((String)",\n").join(this.getAllChangeDescriptions());
    }
}

