/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.extension.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.command.JGitFlowCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.extension.ExtensionCommand;
import com.atlassian.jgitflow.core.extension.ExtensionFailStrategy;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.helper.BranchHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import com.atlassian.maven.plugins.jgitflow.util.NamingUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.Git;

@Component(role=UpdateFeaturePomsWithFinalVersionsCommand.class)
public class UpdateFeaturePomsWithFinalVersionsCommand
implements ExtensionCommand {
    @Requirement
    private ContextProvider contextProvider;
    @Requirement
    private JGitFlowProvider jGitFlowProvider;
    @Requirement
    private PomUpdater pomUpdater;
    @Requirement
    private ProjectHelper projectHelper;
    @Requirement
    private BranchHelper branchHelper;

    public void execute(GitFlowConfiguration configuration, Git git, JGitFlowCommand gitFlowCommand) throws JGitFlowExtensionException {
        String unprefixedBranchName = "";
        try {
            ReleaseContext ctx = this.contextProvider.getContext();
            if (!ctx.isEnableFeatureVersions()) {
                return;
            }
            JGitFlow flow = this.jGitFlowProvider.gitFlow();
            unprefixedBranchName = this.branchHelper.getUnprefixedCurrentBranchName();
            List<MavenProject> branchProjects = this.branchHelper.getProjectsForCurrentBranch();
            String featureVersion = NamingUtil.camelCaseOrSpaceToDashed(unprefixedBranchName);
            featureVersion = StringUtils.replace((String)featureVersion, (String)"-", (String)"_");
            this.pomUpdater.removeFeatureVersionFromSnapshotVersions(ProjectCacheKey.FEATURE_FINISH_LABEL, featureVersion, branchProjects);
            this.projectHelper.commitAllPoms(flow.git(), branchProjects, ctx.getScmCommentPrefix() + "updating poms for " + featureVersion + " version" + ctx.getScmCommentSuffix());
        }
        catch (Exception e) {
            throw new JGitFlowExtensionException("Error updating poms with feature versions for branch '" + unprefixedBranchName + "'", (Throwable)e);
        }
    }

    public ExtensionFailStrategy failStrategy() {
        return ExtensionFailStrategy.ERROR;
    }
}

