/*
 * Decompiled with CFR 0.152.
 */
package exchange.core2.collections.objpool;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ObjectsPool {
    public static final int ORDER = 0;
    public static final int DIRECT_ORDER = 1;
    public static final int DIRECT_BUCKET = 2;
    public static final int ART_NODE_4 = 8;
    public static final int ART_NODE_16 = 9;
    public static final int ART_NODE_48 = 10;
    public static final int ART_NODE_256 = 11;
    public static final int SYMBOL_POSITION_RECORD = 12;
    private final ArrayStack[] pools;

    public static ObjectsPool createDefaultTestPool() {
        HashMap<Integer, Integer> objectsPoolConfig = new HashMap<Integer, Integer>();
        objectsPoolConfig.put(1, 512);
        objectsPoolConfig.put(2, 256);
        objectsPoolConfig.put(8, 256);
        objectsPoolConfig.put(9, 128);
        objectsPoolConfig.put(10, 64);
        objectsPoolConfig.put(11, 32);
        return new ObjectsPool(objectsPoolConfig);
    }

    public ObjectsPool(Map<Integer, Integer> sizesConfig) {
        int maxStack = sizesConfig.keySet().stream().max(Integer::compareTo).orElse(0);
        this.pools = new ArrayStack[maxStack + 1];
        sizesConfig.forEach((type, size) -> {
            this.pools[type.intValue()] = new ArrayStack((int)size);
        });
    }

    public <T> T get(int type, Supplier<T> supplier) {
        Object obj = this.pools[type].pop();
        if (obj == null) {
            return supplier.get();
        }
        return (T)obj;
    }

    public <T> T get(int type, Function<ObjectsPool, T> constructor) {
        Object obj = this.pools[type].pop();
        if (obj == null) {
            return constructor.apply(this);
        }
        return (T)obj;
    }

    public void put(int type, Object object) {
        this.pools[type].add(object);
    }

    private static final class ArrayStack {
        private int count;
        private Object[] objects;

        ArrayStack(int fixedSize) {
            this.objects = new Object[fixedSize];
            this.count = 0;
        }

        void add(Object element) {
            if (this.count != this.objects.length) {
                this.objects[this.count] = element;
                ++this.count;
            }
        }

        Object pop() {
            if (this.count != 0) {
                --this.count;
                Object object = this.objects[this.count];
                this.objects[this.count] = null;
                return object;
            }
            return null;
        }
    }
}

