/*
 * Decompiled with CFR 0.152.
 */
package exchange.core2.collections.art;

import exchange.core2.collections.art.ArtNode16;
import exchange.core2.collections.art.ArtNode256;
import exchange.core2.collections.art.ArtNode4;
import exchange.core2.collections.art.IArtNode;
import exchange.core2.collections.art.LongAdaptiveRadixTreeMap;
import exchange.core2.collections.art.LongObjConsumer;
import exchange.core2.collections.objpool.ObjectsPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ArtNode48<V>
implements IArtNode<V> {
    private static final int NODE16_SWITCH_THRESHOLD = 12;
    final byte[] indexes = new byte[256];
    final Object[] nodes = new Object[48];
    private long freeBitMask;
    long nodeKey;
    int nodeLevel;
    byte numChildren;
    private final ObjectsPool objectsPool;

    public ArtNode48(ObjectsPool objectsPool) {
        this.objectsPool = objectsPool;
    }

    void initFromNode16(ArtNode16<V> node16, short subKey, Object newElement) {
        int sourceSize = 16;
        Arrays.fill(this.indexes, (byte)-1);
        this.numChildren = (byte)17;
        this.nodeLevel = node16.nodeLevel;
        this.nodeKey = node16.nodeKey;
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            this.indexes[node16.keys[i]] = i;
            this.nodes[i] = node16.nodes[i];
        }
        this.indexes[subKey] = 16;
        this.nodes[16] = newElement;
        this.freeBitMask = 131071L;
        Arrays.fill(node16.nodes, null);
        this.objectsPool.put(9, node16);
    }

    void initFromNode256(ArtNode256<V> node256) {
        Arrays.fill(this.indexes, (byte)-1);
        this.numChildren = (byte)node256.numChildren;
        this.nodeLevel = node256.nodeLevel;
        this.nodeKey = node256.nodeKey;
        byte idx = 0;
        for (int i = 0; i < 256; ++i) {
            Object node = node256.nodes[i];
            if (node == null) continue;
            this.indexes[i] = idx;
            this.nodes[idx] = node;
            if ((idx = (byte)(idx + 1)) == this.numChildren) break;
        }
        this.freeBitMask = (1L << this.numChildren) - 1L;
        Arrays.fill(node256.nodes, null);
        this.objectsPool.put(11, node256);
    }

    @Override
    public V getValue(long key, int level) {
        if (level != this.nodeLevel && ((key ^ this.nodeKey) & -1L << this.nodeLevel + 8) != 0L) {
            return null;
        }
        short idx = (short)(key >>> this.nodeLevel & 0xFFL);
        byte nodeIndex = this.indexes[idx];
        if (nodeIndex != -1) {
            Object node = this.nodes[nodeIndex];
            return (V)(this.nodeLevel == 0 ? node : ((IArtNode)node).getValue(key, this.nodeLevel - 8));
        }
        return null;
    }

    @Override
    public IArtNode<V> put(long key, int level, V value) {
        Object newElement;
        IArtNode<V> branch;
        if (level != this.nodeLevel && (branch = LongAdaptiveRadixTreeMap.branchIfRequired(key, value, this.nodeKey, this.nodeLevel, this)) != null) {
            return branch;
        }
        short idx = (short)(key >>> this.nodeLevel & 0xFFL);
        byte nodeIndex = this.indexes[idx];
        if (nodeIndex != -1) {
            if (this.nodeLevel == 0) {
                this.nodes[nodeIndex] = value;
            } else {
                IArtNode<V> resizedNode = ((IArtNode)this.nodes[nodeIndex]).put(key, this.nodeLevel - 8, value);
                if (resizedNode != null) {
                    this.nodes[nodeIndex] = resizedNode;
                }
            }
            return null;
        }
        if (this.numChildren != 48) {
            byte freePosition;
            this.indexes[idx] = freePosition = (byte)Long.numberOfTrailingZeros(this.freeBitMask ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.nodeLevel == 0) {
                this.nodes[freePosition] = value;
            } else {
                ArtNode4 newSubNode = this.objectsPool.get(8, ArtNode4::new);
                newSubNode.initFirstKey(key, value);
                this.nodes[freePosition] = newSubNode;
            }
            this.numChildren = (byte)(this.numChildren + 1);
            this.freeBitMask ^= 1L << freePosition;
            return null;
        }
        if (this.nodeLevel == 0) {
            newElement = value;
        } else {
            ArtNode4 newSubNode = this.objectsPool.get(8, ArtNode4::new);
            newSubNode.initFirstKey(key, value);
            newElement = newSubNode;
        }
        ArtNode256 node256 = this.objectsPool.get(11, ArtNode256::new);
        node256.initFromNode48(this, idx, newElement);
        return node256;
    }

    @Override
    public IArtNode<V> remove(long key, int level) {
        if (level != this.nodeLevel && ((key ^ this.nodeKey) & -1L << this.nodeLevel + 8) != 0L) {
            return this;
        }
        short idx = (short)(key >>> this.nodeLevel & 0xFFL);
        byte nodeIndex = this.indexes[idx];
        if (nodeIndex == -1) {
            return this;
        }
        if (this.nodeLevel == 0) {
            this.nodes[nodeIndex] = null;
            this.indexes[idx] = -1;
            this.numChildren = (byte)(this.numChildren - 1);
            this.freeBitMask ^= 1L << nodeIndex;
        } else {
            IArtNode node = (IArtNode)this.nodes[nodeIndex];
            IArtNode resizedNode = node.remove(key, this.nodeLevel - 8);
            if (resizedNode != node) {
                this.nodes[nodeIndex] = resizedNode;
                if (resizedNode == null) {
                    this.numChildren = (byte)(this.numChildren - 1);
                    this.indexes[idx] = -1;
                    this.freeBitMask ^= 1L << nodeIndex;
                }
            }
        }
        if (this.numChildren == 12) {
            ArtNode16 newNode = this.objectsPool.get(9, ArtNode16::new);
            newNode.initFromNode48(this);
            return newNode;
        }
        return this;
    }

    @Override
    public V getCeilingValue(long key, int level) {
        short idx;
        byte index;
        if (level != this.nodeLevel) {
            long mask = -1L << this.nodeLevel + 8;
            long nodeKeyWithMask = this.nodeKey & mask;
            long keyWithMask = key & mask;
            if (nodeKeyWithMask < keyWithMask) {
                return null;
            }
            if (keyWithMask != nodeKeyWithMask) {
                key = 0L;
            }
        }
        if ((index = this.indexes[idx = (short)(key >>> this.nodeLevel & 0xFFL)]) != -1) {
            Object res;
            Object object = res = this.nodeLevel == 0 ? this.nodes[index] : ((IArtNode)this.nodes[index]).getCeilingValue(key, this.nodeLevel - 8);
            if (res != null) {
                return (V)res;
            }
        }
        while ((idx = (short)(idx + 1)) < 256) {
            index = this.indexes[idx];
            if (index == -1) continue;
            if (this.nodeLevel == 0) {
                return (V)this.nodes[index];
            }
            return ((IArtNode)this.nodes[index]).getCeilingValue(0L, this.nodeLevel - 8);
        }
        return null;
    }

    @Override
    public V getFloorValue(long key, int level) {
        short idx;
        byte index;
        if (level != this.nodeLevel) {
            long mask = -1L << this.nodeLevel + 8;
            long nodeKeyWithMask = this.nodeKey & mask;
            long keyWithMask = key & mask;
            if (nodeKeyWithMask > keyWithMask) {
                return null;
            }
            if (keyWithMask != nodeKeyWithMask) {
                key = Long.MAX_VALUE;
            }
        }
        if ((index = this.indexes[idx = (short)(key >>> this.nodeLevel & 0xFFL)]) != -1) {
            Object res;
            Object object = res = this.nodeLevel == 0 ? this.nodes[index] : ((IArtNode)this.nodes[index]).getFloorValue(key, this.nodeLevel - 8);
            if (res != null) {
                return (V)res;
            }
        }
        while ((idx = (short)(idx - 1)) >= 0) {
            index = this.indexes[idx];
            if (index == -1) continue;
            if (this.nodeLevel == 0) {
                return (V)this.nodes[index];
            }
            return ((IArtNode)this.nodes[index]).getFloorValue(Long.MAX_VALUE, this.nodeLevel - 8);
        }
        return null;
    }

    @Override
    public int forEach(LongObjConsumer<V> consumer, int limit) {
        if (this.nodeLevel == 0) {
            long keyBase = this.nodeKey >>> 8 << 8;
            int numFound = 0;
            for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
                if (numFound == limit) {
                    return numFound;
                }
                byte index = this.indexes[i];
                if (index == -1) continue;
                consumer.accept(keyBase + (long)i, this.nodes[index]);
                ++numFound;
            }
            return numFound;
        }
        int numLeft = limit;
        for (int i = 0; i < 256 && numLeft > 0; i = (int)((short)(i + 1))) {
            byte index = this.indexes[i];
            if (index == -1) continue;
            numLeft -= ((IArtNode)this.nodes[index]).forEach(consumer, numLeft);
        }
        return limit - numLeft;
    }

    @Override
    public int forEachDesc(LongObjConsumer<V> consumer, int limit) {
        if (this.nodeLevel == 0) {
            long keyBase = this.nodeKey >>> 8 << 8;
            int numFound = 0;
            for (int i = 255; i >= 0; i = (int)((short)(i - 1))) {
                if (numFound == limit) {
                    return numFound;
                }
                byte index = this.indexes[i];
                if (index == -1) continue;
                consumer.accept(keyBase + (long)i, this.nodes[index]);
                ++numFound;
            }
            return numFound;
        }
        int numLeft = limit;
        for (int i = 255; i >= 0 && numLeft > 0; i = (int)((short)(i - 1))) {
            byte index = this.indexes[i];
            if (index == -1) continue;
            numLeft -= ((IArtNode)this.nodes[index]).forEachDesc(consumer, numLeft);
        }
        return limit - numLeft;
    }

    @Override
    public int size(int limit) {
        if (this.nodeLevel == 0) {
            return this.numChildren;
        }
        int numLeft = limit;
        for (int i = 0; i < 256 && numLeft > 0; i = (int)((short)(i + 1))) {
            byte index = this.indexes[i];
            if (index == -1) continue;
            numLeft -= ((IArtNode)this.nodes[index]).size(numLeft);
        }
        return limit - numLeft;
    }

    @Override
    public void validateInternalState(int level) {
        int i;
        if (this.nodeLevel > level) {
            throw new IllegalStateException("unexpected nodeLevel");
        }
        int found = 0;
        HashSet<Integer> keysSet = new HashSet<Integer>();
        long expectedBitMask = 0L;
        for (i = 0; i < 256; ++i) {
            byte idx = this.indexes[i];
            if (idx == -1) continue;
            if (idx > 47 || idx < -1) {
                throw new IllegalStateException("wrong index");
            }
            keysSet.add(Integer.valueOf(idx));
            ++found;
            if (this.nodes[idx] == null) {
                throw new IllegalStateException("null node");
            }
            expectedBitMask ^= 1L << idx;
        }
        if (this.freeBitMask != expectedBitMask) {
            throw new IllegalStateException("freeBitMask is wrong");
        }
        if (found != this.numChildren) {
            throw new IllegalStateException("wrong numChildren");
        }
        if (keysSet.size() != this.numChildren) {
            throw new IllegalStateException("duplicate keys keysSet=" + keysSet + " numChildren=" + this.numChildren);
        }
        if (this.numChildren > 48 || this.numChildren <= 12) {
            throw new IllegalStateException("unexpected numChildren");
        }
        for (i = 0; i < 48; ++i) {
            Object node = this.nodes[i];
            if (keysSet.contains(i)) {
                if (node == null) {
                    throw new IllegalStateException("null node");
                }
                if (node instanceof IArtNode) {
                    if (this.nodeLevel == 0) {
                        throw new IllegalStateException("unexpected node type");
                    }
                    IArtNode artNode = (IArtNode)node;
                    artNode.validateInternalState(this.nodeLevel - 8);
                    continue;
                }
                if (this.nodeLevel == 0) continue;
                throw new IllegalStateException("unexpected node type");
            }
            if (node == null) continue;
            throw new IllegalStateException("not released node");
        }
    }

    @Override
    public List<Map.Entry<Long, V>> entries() {
        long keyPrefix = this.nodeKey & 0xFFFFFFFFFFFFFF00L;
        ArrayList<Map.Entry<Long, V>> list = new ArrayList<Map.Entry<Long, V>>();
        short[] keys = this.createKeysArray();
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.nodeLevel == 0) {
                list.add(new LongAdaptiveRadixTreeMap.Entry<Object>(keyPrefix + (long)keys[i], this.nodes[this.indexes[keys[i]]]));
                continue;
            }
            list.addAll(((IArtNode)this.nodes[this.indexes[keys[i]]]).entries());
        }
        return list;
    }

    @Override
    public String printDiagram(String prefix, int level) {
        short[] keys = this.createKeysArray();
        return LongAdaptiveRadixTreeMap.printDiagram(prefix, level, this.nodeLevel, this.nodeKey, this.numChildren, idx -> keys[idx], idx -> this.nodes[this.indexes[keys[idx]]]);
    }

    @Override
    public ObjectsPool getObjectsPool() {
        return this.objectsPool;
    }

    public String toString() {
        return "ArtNode48{nodeKey=" + this.nodeKey + ", nodeLevel=" + this.nodeLevel + ", numChildren=" + this.numChildren + '}';
    }

    private short[] createKeysArray() {
        short[] keys = new short[this.numChildren];
        int j = 0;
        for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
            if (this.indexes[i] == -1) continue;
            keys[j++] = i;
        }
        return keys;
    }
}

