/*
 * Decompiled with CFR 0.152.
 */
package exchange.core2.collections.art;

import exchange.core2.collections.art.ArtNode16;
import exchange.core2.collections.art.IArtNode;
import exchange.core2.collections.art.LongAdaptiveRadixTreeMap;
import exchange.core2.collections.art.LongObjConsumer;
import exchange.core2.collections.objpool.ObjectsPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ArtNode4<V>
implements IArtNode<V> {
    final short[] keys = new short[4];
    final Object[] nodes = new Object[4];
    private final ObjectsPool objectsPool;
    long nodeKey;
    int nodeLevel;
    byte numChildren;

    public ArtNode4(ObjectsPool objectsPool) {
        this.objectsPool = objectsPool;
    }

    void initFirstKey(long key, V value) {
        this.numChildren = 1;
        this.keys[0] = (short)(key & 0xFFL);
        this.nodes[0] = value;
        this.nodeKey = key;
        this.nodeLevel = 0;
    }

    void initTwoKeys(long key1, Object value1, long key2, Object value2, int level) {
        this.numChildren = (byte)2;
        short idx1 = (short)(key1 >> level & 0xFFL);
        short idx2 = (short)(key2 >> level & 0xFFL);
        if (key1 < key2) {
            this.keys[0] = idx1;
            this.nodes[0] = value1;
            this.keys[1] = idx2;
            this.nodes[1] = value2;
        } else {
            this.keys[0] = idx2;
            this.nodes[0] = value2;
            this.keys[1] = idx1;
            this.nodes[1] = value1;
        }
        this.nodeKey = key1;
        this.nodeLevel = level;
    }

    void initFromNode16(ArtNode16 artNode16) {
        this.objectsPool.put(9, artNode16);
        this.numChildren = artNode16.numChildren;
        System.arraycopy(artNode16.keys, 0, this.keys, 0, this.numChildren);
        System.arraycopy(artNode16.nodes, 0, this.nodes, 0, this.numChildren);
        this.nodeLevel = artNode16.nodeLevel;
        this.nodeKey = artNode16.nodeKey;
        Arrays.fill(artNode16.nodes, null);
    }

    @Override
    public V getValue(long key, int level) {
        if (level != this.nodeLevel && ((key ^ this.nodeKey) & -1L << this.nodeLevel + 8) != 0L) {
            return null;
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        for (int i = 0; i < this.numChildren; ++i) {
            short index = this.keys[i];
            if (index == nodeIndex) {
                Object node = this.nodes[i];
                return (V)(this.nodeLevel == 0 ? node : ((IArtNode)node).getValue(key, this.nodeLevel - 8));
            }
            if (nodeIndex < index) break;
        }
        return null;
    }

    @Override
    public IArtNode<V> put(long key, int level, V value) {
        Object newElement;
        int pos;
        IArtNode<V> branch;
        if (level != this.nodeLevel && (branch = LongAdaptiveRadixTreeMap.branchIfRequired(key, value, this.nodeKey, this.nodeLevel, this)) != null) {
            return branch;
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        for (pos = 0; pos < this.numChildren; ++pos) {
            if (nodeIndex == this.keys[pos]) {
                if (this.nodeLevel == 0) {
                    this.nodes[pos] = value;
                } else {
                    IArtNode<V> resizedNode = ((IArtNode)this.nodes[pos]).put(key, this.nodeLevel - 8, value);
                    if (resizedNode != null) {
                        this.nodes[pos] = resizedNode;
                    }
                }
                return null;
            }
            if (nodeIndex < this.keys[pos]) break;
        }
        if (this.numChildren != 4) {
            int copyLength = this.numChildren - pos;
            if (copyLength != 0) {
                System.arraycopy(this.keys, pos, this.keys, pos + 1, copyLength);
                System.arraycopy(this.nodes, pos, this.nodes, pos + 1, copyLength);
            }
            this.keys[pos] = nodeIndex;
            if (this.nodeLevel == 0) {
                this.nodes[pos] = value;
            } else {
                ArtNode4 newSubNode = this.objectsPool.get(8, ArtNode4::new);
                newSubNode.initFirstKey(key, value);
                this.nodes[pos] = newSubNode;
            }
            this.numChildren = (byte)(this.numChildren + 1);
            return null;
        }
        if (this.nodeLevel == 0) {
            newElement = value;
        } else {
            ArtNode4 newSubNode = this.objectsPool.get(8, ArtNode4::new);
            newSubNode.initFirstKey(key, value);
            newElement = newSubNode;
        }
        ArtNode16 node16 = this.objectsPool.get(9, ArtNode16::new);
        node16.initFromNode4(this, nodeIndex, newElement);
        return node16;
    }

    public String toString() {
        return "ArtNode4{nodeKey=" + this.nodeKey + ", nodeLevel=" + this.nodeLevel + ", numChildren=" + this.numChildren + '}';
    }

    @Override
    public IArtNode<V> remove(long key, int level) {
        int pos;
        if (level != this.nodeLevel && ((key ^ this.nodeKey) & -1L << this.nodeLevel + 8) != 0L) {
            return this;
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        Object node = null;
        for (pos = 0; pos < this.numChildren; ++pos) {
            if (nodeIndex != this.keys[pos]) continue;
            node = this.nodes[pos];
            break;
        }
        if (node == null) {
            return this;
        }
        if (this.nodeLevel == 0) {
            this.removeElementAtPos(pos);
        } else {
            IArtNode resizedNode = ((IArtNode)node).remove(key, this.nodeLevel - 8);
            if (resizedNode != node) {
                this.nodes[pos] = resizedNode;
                if (resizedNode == null) {
                    this.removeElementAtPos(pos);
                    if (this.numChildren == 1) {
                        IArtNode lastNode = (IArtNode)this.nodes[0];
                        return lastNode;
                    }
                }
            }
        }
        if (this.numChildren == 0) {
            Arrays.fill(this.nodes, null);
            this.objectsPool.put(8, this);
            return null;
        }
        return this;
    }

    @Override
    public V getCeilingValue(long key, int level) {
        if (level != this.nodeLevel) {
            long mask = -1L << this.nodeLevel + 8;
            long nodeKeyWithMask = this.nodeKey & mask;
            long keyWithMask = key & mask;
            if (nodeKeyWithMask < keyWithMask) {
                return null;
            }
            if (keyWithMask != nodeKeyWithMask) {
                key = 0L;
            }
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        for (int i = 0; i < this.numChildren; ++i) {
            short index = this.keys[i];
            if (index == nodeIndex) {
                Object res;
                Object object = res = this.nodeLevel == 0 ? this.nodes[i] : ((IArtNode)this.nodes[i]).getCeilingValue(key, this.nodeLevel - 8);
                if (res != null) {
                    return (V)res;
                }
            }
            if (index <= nodeIndex) continue;
            return (V)(this.nodeLevel == 0 ? this.nodes[i] : ((IArtNode)this.nodes[i]).getCeilingValue(0L, this.nodeLevel - 8));
        }
        return null;
    }

    @Override
    public V getFloorValue(long key, int level) {
        if (level != this.nodeLevel) {
            long mask = -1L << this.nodeLevel + 8;
            long nodeKeyWithMask = this.nodeKey & mask;
            long keyWithMask = key & mask;
            if (nodeKeyWithMask > keyWithMask) {
                return null;
            }
            if (keyWithMask != nodeKeyWithMask) {
                key = Long.MAX_VALUE;
            }
        }
        short nodeIndex = (short)(key >>> this.nodeLevel & 0xFFL);
        for (int i = this.numChildren - 1; i >= 0; --i) {
            short index = this.keys[i];
            if (index == nodeIndex) {
                Object res;
                Object object = res = this.nodeLevel == 0 ? this.nodes[i] : ((IArtNode)this.nodes[i]).getFloorValue(key, this.nodeLevel - 8);
                if (res != null) {
                    return (V)res;
                }
            }
            if (index >= nodeIndex) continue;
            return (V)(this.nodeLevel == 0 ? this.nodes[i] : ((IArtNode)this.nodes[i]).getFloorValue(Long.MAX_VALUE, this.nodeLevel - 8));
        }
        return null;
    }

    @Override
    public int forEach(LongObjConsumer<V> consumer, int limit) {
        if (this.nodeLevel == 0) {
            long keyBase = this.nodeKey >>> 8 << 8;
            int n = Math.min(this.numChildren, limit);
            for (int i = 0; i < n; ++i) {
                consumer.accept(keyBase + (long)this.keys[i], this.nodes[i]);
            }
            return n;
        }
        int numLeft = limit;
        for (int i = 0; i < this.numChildren && numLeft > 0; numLeft -= ((IArtNode)this.nodes[i]).forEach(consumer, numLeft), ++i) {
        }
        return limit - numLeft;
    }

    @Override
    public int forEachDesc(LongObjConsumer<V> consumer, int limit) {
        if (this.nodeLevel == 0) {
            long keyBase = this.nodeKey >>> 8 << 8;
            int numFound = 0;
            for (int i = this.numChildren - 1; i >= 0 && numFound < limit; ++numFound, --i) {
                consumer.accept(keyBase + (long)this.keys[i], this.nodes[i]);
            }
            return numFound;
        }
        int numLeft = limit;
        for (int i = this.numChildren - 1; i >= 0 && numLeft > 0; numLeft -= ((IArtNode)this.nodes[i]).forEachDesc(consumer, numLeft), --i) {
        }
        return limit - numLeft;
    }

    @Override
    public int size(int limit) {
        if (this.nodeLevel == 0) {
            return this.numChildren;
        }
        int numLeft = limit;
        for (int i = this.numChildren - 1; i >= 0 && numLeft > 0; numLeft -= ((IArtNode)this.nodes[i]).size(numLeft), --i) {
        }
        return limit - numLeft;
    }

    private void removeElementAtPos(int pos) {
        int ppos = pos + 1;
        int copyLength = this.numChildren - ppos;
        if (copyLength != 0) {
            System.arraycopy(this.keys, ppos, this.keys, pos, copyLength);
            System.arraycopy(this.nodes, ppos, this.nodes, pos, copyLength);
        }
        this.numChildren = (byte)(this.numChildren - 1);
        this.nodes[this.numChildren] = null;
    }

    @Override
    public void validateInternalState(int level) {
        if (this.nodeLevel > level) {
            throw new IllegalStateException("unexpected nodeLevel");
        }
        if (this.numChildren > 4 || this.numChildren < 1) {
            throw new IllegalStateException("unexpected numChildren");
        }
        short last = -1;
        for (int i = 0; i < 4; ++i) {
            Object node = this.nodes[i];
            if (i < this.numChildren) {
                if (node == null) {
                    throw new IllegalStateException("null node");
                }
                if (this.keys[i] < 0 || this.keys[i] >= 256) {
                    throw new IllegalStateException("key out of range");
                }
                if (this.keys[i] == last) {
                    throw new IllegalStateException("duplicate key");
                }
                if (this.keys[i] < last) {
                    throw new IllegalStateException("wrong key order");
                }
                last = this.keys[i];
                if (node instanceof IArtNode) {
                    if (this.nodeLevel == 0) {
                        throw new IllegalStateException("unexpected node type");
                    }
                    IArtNode artNode = (IArtNode)node;
                    artNode.validateInternalState(this.nodeLevel - 8);
                    continue;
                }
                if (this.nodeLevel == 0) continue;
                throw new IllegalStateException("unexpected node type");
            }
            if (node == null) continue;
            throw new IllegalStateException("not released node");
        }
    }

    @Override
    public String printDiagram(String prefix, int level) {
        return LongAdaptiveRadixTreeMap.printDiagram(prefix, level, this.nodeLevel, this.nodeKey, this.numChildren, idx -> this.keys[idx], idx -> this.nodes[idx]);
    }

    @Override
    public List<Map.Entry<Long, V>> entries() {
        long keyPrefix = this.nodeKey & 0xFFFFFFFFFFFFFF00L;
        ArrayList<Map.Entry<Long, V>> list = new ArrayList<Map.Entry<Long, V>>();
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.nodeLevel == 0) {
                list.add(new LongAdaptiveRadixTreeMap.Entry<Object>(keyPrefix + (long)this.keys[i], this.nodes[i]));
                continue;
            }
            list.addAll(((IArtNode)this.nodes[i]).entries());
        }
        return list;
    }

    @Override
    public ObjectsPool getObjectsPool() {
        return this.objectsPool;
    }
}

