/*
 * Decompiled with CFR 0.152.
 */
package exchange.core2.collections.art;

import exchange.core2.collections.art.ArtNode4;
import exchange.core2.collections.art.ArtNode48;
import exchange.core2.collections.art.IArtNode;
import exchange.core2.collections.art.LongAdaptiveRadixTreeMap;
import exchange.core2.collections.art.LongObjConsumer;
import exchange.core2.collections.objpool.ObjectsPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ArtNode256<V>
implements IArtNode<V> {
    private static final int NODE48_SWITCH_THRESHOLD = 37;
    final Object[] nodes = new Object[256];
    long nodeKey;
    int nodeLevel;
    short numChildren;
    private final ObjectsPool objectsPool;

    public ArtNode256(ObjectsPool objectsPool) {
        this.objectsPool = objectsPool;
    }

    void initFromNode48(ArtNode48<V> artNode48, short subKey, Object newElement) {
        this.nodeLevel = artNode48.nodeLevel;
        this.nodeKey = artNode48.nodeKey;
        int sourceSize = 48;
        for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
            byte index = artNode48.indexes[i];
            if (index == -1) continue;
            this.nodes[i] = artNode48.nodes[index];
        }
        this.nodes[subKey] = newElement;
        this.numChildren = (short)49;
        Arrays.fill(artNode48.nodes, null);
        Arrays.fill(artNode48.indexes, (byte)-1);
        this.objectsPool.put(10, artNode48);
    }

    @Override
    public V getValue(long key, int level) {
        if (level != this.nodeLevel && ((key ^ this.nodeKey) & -1L << this.nodeLevel + 8) != 0L) {
            return null;
        }
        short idx = (short)(key >>> this.nodeLevel & 0xFFL);
        Object node = this.nodes[idx];
        if (node != null) {
            return (V)(this.nodeLevel == 0 ? node : ((IArtNode)node).getValue(key, this.nodeLevel - 8));
        }
        return null;
    }

    @Override
    public IArtNode<V> put(long key, int level, V value) {
        IArtNode<V> branch;
        if (level != this.nodeLevel && (branch = LongAdaptiveRadixTreeMap.branchIfRequired(key, value, this.nodeKey, this.nodeLevel, this)) != null) {
            return branch;
        }
        short idx = (short)(key >>> this.nodeLevel & 0xFFL);
        if (this.nodes[idx] == null) {
            this.numChildren = (short)(this.numChildren + 1);
        }
        if (this.nodeLevel == 0) {
            this.nodes[idx] = value;
        } else {
            IArtNode node = (IArtNode)this.nodes[idx];
            if (node != null) {
                IArtNode<V> resizedNode = node.put(key, this.nodeLevel - 8, value);
                if (resizedNode != null) {
                    this.nodes[idx] = resizedNode;
                }
            } else {
                ArtNode4 newSubNode = this.objectsPool.get(8, ArtNode4::new);
                newSubNode.initFirstKey(key, value);
                this.nodes[idx] = newSubNode;
            }
        }
        return null;
    }

    @Override
    public IArtNode<V> remove(long key, int level) {
        if (level != this.nodeLevel && ((key ^ this.nodeKey) & -1L << this.nodeLevel + 8) != 0L) {
            return this;
        }
        short idx = (short)(key >>> this.nodeLevel & 0xFFL);
        if (this.nodes[idx] == null) {
            return this;
        }
        if (this.nodeLevel == 0) {
            this.nodes[idx] = null;
            this.numChildren = (short)(this.numChildren - 1);
        } else {
            IArtNode node = (IArtNode)this.nodes[idx];
            IArtNode resizedNode = node.remove(key, this.nodeLevel - 8);
            if (resizedNode != node) {
                this.nodes[idx] = resizedNode;
                if (resizedNode == null) {
                    this.numChildren = (short)(this.numChildren - 1);
                }
            }
        }
        if (this.numChildren == 37) {
            ArtNode48 newNode = this.objectsPool.get(10, ArtNode48::new);
            newNode.initFromNode256(this);
            return newNode;
        }
        return this;
    }

    @Override
    public V getCeilingValue(long key, int level) {
        short idx;
        Object node;
        if (level != this.nodeLevel) {
            long mask = -1L << this.nodeLevel + 8;
            long nodeKeyWithMask = this.nodeKey & mask;
            long keyWithMask = key & mask;
            if (nodeKeyWithMask < keyWithMask) {
                return null;
            }
            if (keyWithMask != nodeKeyWithMask) {
                key = 0L;
            }
        }
        if ((node = this.nodes[idx = (short)(key >>> this.nodeLevel & 0xFFL)]) != null) {
            Object res;
            Object object = res = this.nodeLevel == 0 ? node : ((IArtNode)node).getCeilingValue(key, this.nodeLevel - 8);
            if (res != null) {
                return (V)res;
            }
        }
        while ((idx = (short)(idx + 1)) < 256) {
            node = this.nodes[idx];
            if (node == null) continue;
            return (V)(this.nodeLevel == 0 ? node : ((IArtNode)node).getCeilingValue(0L, this.nodeLevel - 8));
        }
        return null;
    }

    @Override
    public V getFloorValue(long key, int level) {
        short idx;
        Object node;
        if (level != this.nodeLevel) {
            long mask = -1L << this.nodeLevel + 8;
            long nodeKeyWithMask = this.nodeKey & mask;
            long keyWithMask = key & mask;
            if (nodeKeyWithMask > keyWithMask) {
                return null;
            }
            if (keyWithMask != nodeKeyWithMask) {
                key = Long.MAX_VALUE;
            }
        }
        if ((node = this.nodes[idx = (short)(key >>> this.nodeLevel & 0xFFL)]) != null) {
            Object res;
            Object object = res = this.nodeLevel == 0 ? node : ((IArtNode)node).getFloorValue(key, this.nodeLevel - 8);
            if (res != null) {
                return (V)res;
            }
        }
        while ((idx = (short)(idx - 1)) >= 0) {
            node = this.nodes[idx];
            if (node == null) continue;
            return (V)(this.nodeLevel == 0 ? node : ((IArtNode)node).getFloorValue(Long.MAX_VALUE, this.nodeLevel - 8));
        }
        return null;
    }

    @Override
    public int forEach(LongObjConsumer<V> consumer, int limit) {
        if (this.nodeLevel == 0) {
            long keyBase = this.nodeKey >>> 8 << 8;
            int numFound = 0;
            for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
                if (numFound == limit) {
                    return numFound;
                }
                Object node = this.nodes[i];
                if (node == null) continue;
                consumer.accept(keyBase + (long)i, node);
                ++numFound;
            }
            return numFound;
        }
        int numLeft = limit;
        for (int i = 0; i < 256 && numLeft > 0; i = (int)((short)(i + 1))) {
            IArtNode node = (IArtNode)this.nodes[i];
            if (node == null) continue;
            numLeft -= node.forEach(consumer, numLeft);
        }
        return limit - numLeft;
    }

    @Override
    public int forEachDesc(LongObjConsumer<V> consumer, int limit) {
        if (this.nodeLevel == 0) {
            long keyBase = this.nodeKey >>> 8 << 8;
            int numFound = 0;
            for (int i = 255; i >= 0; i = (int)((short)(i - 1))) {
                if (numFound == limit) {
                    return numFound;
                }
                Object node = this.nodes[i];
                if (node == null) continue;
                consumer.accept(keyBase + (long)i, node);
                ++numFound;
            }
            return numFound;
        }
        int numLeft = limit;
        for (int i = 255; i >= 0 && numLeft > 0; i = (int)((short)(i - 1))) {
            IArtNode node = (IArtNode)this.nodes[i];
            if (node == null) continue;
            numLeft -= node.forEachDesc(consumer, numLeft);
        }
        return limit - numLeft;
    }

    @Override
    public int size(int limit) {
        if (this.nodeLevel == 0) {
            return this.numChildren;
        }
        int numLeft = limit;
        for (int i = 0; i < 256 && numLeft > 0; i = (int)((short)(i + 1))) {
            IArtNode node = (IArtNode)this.nodes[i];
            if (node == null) continue;
            numLeft -= node.size(numLeft);
        }
        return limit - numLeft;
    }

    @Override
    public void validateInternalState(int level) {
        if (this.nodeLevel > level) {
            throw new IllegalStateException("unexpected nodeLevel");
        }
        int found = 0;
        for (int i = 0; i < 256; ++i) {
            Object node = this.nodes[i];
            if (node == null) continue;
            if (node instanceof IArtNode) {
                if (this.nodeLevel == 0) {
                    throw new IllegalStateException("unexpected node type");
                }
                IArtNode artNode = (IArtNode)node;
                artNode.validateInternalState(this.nodeLevel - 8);
            } else if (this.nodeLevel != 0) {
                throw new IllegalStateException("unexpected node type");
            }
            ++found;
        }
        if (found != this.numChildren) {
            throw new IllegalStateException("wrong numChildren");
        }
        if (this.numChildren <= 37 || this.numChildren > 256) {
            throw new IllegalStateException("unexpected numChildren");
        }
    }

    @Override
    public List<Map.Entry<Long, V>> entries() {
        long keyPrefix = this.nodeKey & 0xFFFFFFFFFFFFFF00L;
        ArrayList<Map.Entry<Long, V>> list = new ArrayList<Map.Entry<Long, V>>();
        short[] keys = this.createKeysArray();
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.nodeLevel == 0) {
                list.add(new LongAdaptiveRadixTreeMap.Entry<Object>(keyPrefix + (long)keys[i], this.nodes[keys[i]]));
                continue;
            }
            list.addAll(((IArtNode)this.nodes[keys[i]]).entries());
        }
        return list;
    }

    @Override
    public String printDiagram(String prefix, int level) {
        short[] keys = this.createKeysArray();
        return LongAdaptiveRadixTreeMap.printDiagram(prefix, level, this.nodeLevel, this.nodeKey, this.numChildren, idx -> keys[idx], idx -> this.nodes[keys[idx]]);
    }

    @Override
    public ObjectsPool getObjectsPool() {
        return this.objectsPool;
    }

    public String toString() {
        return "ArtNode256{nodeKey=" + this.nodeKey + ", nodeLevel=" + this.nodeLevel + ", numChildren=" + this.numChildren + '}';
    }

    private short[] createKeysArray() {
        short[] keys = new short[this.numChildren];
        int j = 0;
        for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
            if (this.nodes[i] == null) continue;
            keys[j++] = i;
        }
        return keys;
    }
}

