/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons.validation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import eu.trentorise.opendata.commons.validation.ARef;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class Ref
extends ARef {
    private final String documentId;
    private final long physicalRow;
    private final long physicalColumn;
    private final String tracePath;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final Ref INSTANCE = Ref.validate(new Ref());
    private static final long serialVersionUID = 1L;

    private Ref() {
        this.documentId = this.initShim.getDocumentId();
        this.physicalRow = this.initShim.getPhysicalRow();
        this.physicalColumn = this.initShim.getPhysicalColumn();
        this.tracePath = this.initShim.getTracePath();
        this.initShim = null;
    }

    private Ref(Builder builder) {
        if (builder.documentId != null) {
            this.initShim.setDocumentId(builder.documentId);
        }
        if (builder.physicalRowIsSet()) {
            this.initShim.setPhysicalRow(builder.physicalRow);
        }
        if (builder.physicalColumnIsSet()) {
            this.initShim.setPhysicalColumn(builder.physicalColumn);
        }
        if (builder.tracePath != null) {
            this.initShim.setTracePath(builder.tracePath);
        }
        this.documentId = this.initShim.getDocumentId();
        this.physicalRow = this.initShim.getPhysicalRow();
        this.physicalColumn = this.initShim.getPhysicalColumn();
        this.tracePath = this.initShim.getTracePath();
        this.initShim = null;
    }

    private Ref(String documentId, long physicalRow, long physicalColumn, String tracePath) {
        this.documentId = documentId;
        this.physicalRow = physicalRow;
        this.physicalColumn = physicalColumn;
        this.tracePath = tracePath;
        this.initShim = null;
    }

    @Override
    public String getDocumentId() {
        return this.initShim != null ? this.initShim.getDocumentId() : this.documentId;
    }

    @Override
    public long getPhysicalRow() {
        return this.initShim != null ? this.initShim.getPhysicalRow() : this.physicalRow;
    }

    @Override
    public long getPhysicalColumn() {
        return this.initShim != null ? this.initShim.getPhysicalColumn() : this.physicalColumn;
    }

    @Override
    public String getTracePath() {
        return this.initShim != null ? this.initShim.getTracePath() : this.tracePath;
    }

    public final Ref withDocumentId(String value) {
        if (this.documentId == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return Ref.validate(new Ref(newValue, this.physicalRow, this.physicalColumn, this.tracePath));
    }

    public final Ref withPhysicalRow(long value) {
        if (this.physicalRow == value) {
            return this;
        }
        long newValue = value;
        return Ref.validate(new Ref(this.documentId, newValue, this.physicalColumn, this.tracePath));
    }

    public final Ref withPhysicalColumn(long value) {
        if (this.physicalColumn == value) {
            return this;
        }
        long newValue = value;
        return Ref.validate(new Ref(this.documentId, this.physicalRow, newValue, this.tracePath));
    }

    public final Ref withTracePath(String value) {
        if (this.tracePath == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return Ref.validate(new Ref(this.documentId, this.physicalRow, this.physicalColumn, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Ref && this.equalTo((Ref)another);
    }

    private boolean equalTo(Ref another) {
        return this.documentId.equals(another.documentId) && this.physicalRow == another.physicalRow && this.physicalColumn == another.physicalColumn && this.tracePath.equals(another.tracePath);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.documentId.hashCode();
        h = h * 17 + Longs.hashCode((long)this.physicalRow);
        h = h * 17 + Longs.hashCode((long)this.physicalColumn);
        h = h * 17 + this.tracePath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Ref").add("documentId", (Object)this.documentId).add("physicalRow", this.physicalRow).add("physicalColumn", this.physicalColumn).add("tracePath", (Object)this.tracePath).toString();
    }

    public static Ref of() {
        return INSTANCE;
    }

    private static Ref validate(Ref instance) {
        instance.check();
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static Ref copyOf(Ref instance) {
        if (instance instanceof Ref) {
            return instance;
        }
        return Ref.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Ref.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_PHYSICAL_ROW = 1L;
        private static final long OPT_BIT_PHYSICAL_COLUMN = 2L;
        private long optBits;
        @Nullable
        private String documentId;
        private long physicalRow;
        private long physicalColumn;
        @Nullable
        private String tracePath;

        private Builder() {
        }

        public final Builder from(Ref instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setDocumentId(instance.getDocumentId());
            this.setPhysicalRow(instance.getPhysicalRow());
            this.setPhysicalColumn(instance.getPhysicalColumn());
            this.setTracePath(instance.getTracePath());
            return this;
        }

        public final Builder setDocumentId(String documentId) {
            this.documentId = (String)Preconditions.checkNotNull((Object)documentId);
            return this;
        }

        public final Builder setPhysicalRow(long physicalRow) {
            this.physicalRow = physicalRow;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setPhysicalColumn(long physicalColumn) {
            this.physicalColumn = physicalColumn;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setTracePath(String tracePath) {
            this.tracePath = (String)Preconditions.checkNotNull((Object)tracePath);
            return this;
        }

        public Ref build() throws IllegalStateException {
            return Ref.validate(new Ref(this));
        }

        private boolean physicalRowIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean physicalColumnIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private String documentId;
        private byte documentIdStage;
        private long physicalRow;
        private byte physicalRowStage;
        private long physicalColumn;
        private byte physicalColumnStage;
        private String tracePath;
        private byte tracePathStage;

        private InitShim() {
        }

        String getDocumentId() {
            if (this.documentIdStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.documentIdStage == 0) {
                this.documentIdStage = (byte)-1;
                this.documentId = (String)Preconditions.checkNotNull((Object)Ref.super.getDocumentId());
                this.documentIdStage = 1;
            }
            return this.documentId;
        }

        String setDocumentId(String value) {
            this.documentId = value;
            this.documentIdStage = 1;
            return value;
        }

        long getPhysicalRow() {
            if (this.physicalRowStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.physicalRowStage == 0) {
                this.physicalRowStage = (byte)-1;
                this.physicalRow = Ref.super.getPhysicalRow();
                this.physicalRowStage = 1;
            }
            return this.physicalRow;
        }

        long setPhysicalRow(long value) {
            this.physicalRow = value;
            this.physicalRowStage = 1;
            return value;
        }

        long getPhysicalColumn() {
            if (this.physicalColumnStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.physicalColumnStage == 0) {
                this.physicalColumnStage = (byte)-1;
                this.physicalColumn = Ref.super.getPhysicalColumn();
                this.physicalColumnStage = 1;
            }
            return this.physicalColumn;
        }

        long setPhysicalColumn(long value) {
            this.physicalColumn = value;
            this.physicalColumnStage = 1;
            return value;
        }

        String getTracePath() {
            if (this.tracePathStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tracePathStage == 0) {
                this.tracePathStage = (byte)-1;
                this.tracePath = (String)Preconditions.checkNotNull((Object)Ref.super.getTracePath());
                this.tracePathStage = 1;
            }
            return this.tracePath;
        }

        String setTracePath(String value) {
            this.tracePath = value;
            this.tracePathStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.documentIdStage == -1) {
                attributes.add("documentId");
            }
            if (this.physicalRowStage == -1) {
                attributes.add("physicalRow");
            }
            if (this.physicalColumnStage == -1) {
                attributes.add("physicalColumn");
            }
            if (this.tracePathStage == -1) {
                attributes.add("tracePath");
            }
            return "Cannot build Ref, attribute initializers form cycle" + attributes;
        }
    }
}

