/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import com.google.common.base.Preconditions;
import eu.trentorise.opendata.commons.BuildInfo;
import eu.trentorise.opendata.commons.NotFoundException;
import eu.trentorise.opendata.commons.TodException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class TodConfig {
    public static final String LOG_PROPERTIES_PATH = "tod.commons.logging.properties";
    public static final String LOG_PROPERTIES_CONF_PATH = "conf/tod.commons.logging.properties";
    public static final String BUILD_PROPERTIES_PATH = "tod.commons.build.properties";
    private static final Logger LOG = Logger.getLogger(TodConfig.class.getName());
    private static final Map<Class, TodConfig> INSTANCES = new HashMap<Class, TodConfig>();
    private static boolean loggingConfigured = false;
    private Class referenceClass;
    @Nullable
    private BuildInfo buildInfo;

    private TodConfig() {
        this.referenceClass = this.getClass();
    }

    private TodConfig(Class clazz) {
        this.referenceClass = clazz;
    }

    public BuildInfo getBuildInfo() {
        if (this.buildInfo == null) {
            try {
                InputStream stream = this.referenceClass.getResourceAsStream("/tod.commons.build.properties");
                Properties props = new Properties();
                if (stream == null) {
                    throw new NotFoundException("Couldn't find tod.commons.build.properties file in resources of package containing class " + this.referenceClass.getSimpleName() + "  !!");
                }
                try {
                    props.load(stream);
                }
                catch (IOException ex) {
                    throw new TodException("Couldn't load tod.commons.build.properties file in resources of package containing class " + this.referenceClass.getSimpleName() + "  !!", ex);
                }
                this.buildInfo = BuildInfo.builder().setBuildJdk(props.getProperty("build-jdk", "")).setBuiltBy(props.getProperty("built-by", "")).setCreatedBy(props.getProperty("created-by", "")).setGitSha(props.getProperty("git-sha", "")).setScmUrl(props.getProperty("scm-url", "")).setTimestamp(props.getProperty("timestamp", "")).setVersion(props.getProperty("version", "")).build();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "COULD NOT LOAD BUILD INFORMATION! DEFAULTING TO EMPTY BUILD INFO!", ex);
                this.buildInfo = BuildInfo.of();
            }
        }
        return this.buildInfo;
    }

    public static void loadLogConfig(Class referenceClass) {
        if (loggingConfigured) {
            LOG.finest("Trying to reload twice logger properties!");
        } else {
            System.out.print(referenceClass.getSimpleName() + ": searching logging config in " + LOG_PROPERTIES_CONF_PATH + ":");
            InputStream inputStream = null;
            String configured = "";
            try {
                inputStream = new FileInputStream(LOG_PROPERTIES_CONF_PATH);
                System.out.println("  found.");
                configured = referenceClass.getSimpleName() + ": logging configured.";
            }
            catch (Exception ex) {
                System.out.println("  not found.");
            }
            try {
                if (inputStream == null) {
                    System.out.println(referenceClass.getSimpleName() + ": searching logging config in default " + LOG_PROPERTIES_PATH + " from resources... ");
                    URL url = referenceClass.getResource("/tod.commons.logging.properties");
                    if (url == null) {
                        System.out.println();
                        throw new IOException("ERROR! COULDN'T FIND ANY LOG CONFIGURATION FILE NAMED tod.commons.logging.properties from reference class " + referenceClass.getName());
                    }
                    inputStream = referenceClass.getResourceAsStream("/tod.commons.logging.properties");
                    String path = url.toURI().getPath();
                    configured = TodConfig.class.getSimpleName() + ": configured logging with " + path;
                }
                LogManager.getLogManager().readConfiguration(inputStream);
                Logger loggerWorkaround = Logger.getLogger(referenceClass.getName() + ".workaround");
                loggingConfigured = true;
                System.out.println(configured);
            }
            catch (Exception e) {
                System.out.println("ERROR - COULDN'T LOAD LOGGING PROPERTIES!");
                e.printStackTrace();
            }
        }
    }

    public static boolean isLoggingConfigured() {
        return loggingConfigured;
    }

    public static TodConfig init(Class clazz) {
        TodConfig ret = TodConfig.of(clazz);
        TodConfig.loadLogConfig(clazz);
        return ret;
    }

    public static synchronized TodConfig of(Class clazz) {
        Preconditions.checkNotNull((Object)clazz);
        if (!INSTANCES.containsKey(clazz)) {
            INSTANCES.put(clazz, new TodConfig(clazz));
        }
        return INSTANCES.get(clazz);
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }
}

