/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.ALocalizedString;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class LocalizedString
extends ALocalizedString {
    private final Locale locale;
    private final String string;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final LocalizedString INSTANCE = LocalizedString.validate(new LocalizedString());
    private static final long serialVersionUID = 1L;

    private LocalizedString() {
        this.locale = this.initShim.getLocale();
        this.string = this.initShim.getString();
        this.initShim = null;
    }

    private LocalizedString(Locale locale, String string) {
        this.locale = (Locale)Preconditions.checkNotNull((Object)locale);
        this.string = (String)Preconditions.checkNotNull((Object)string);
        this.initShim = null;
    }

    private LocalizedString(LocalizedString original, Locale locale, String string) {
        this.locale = locale;
        this.string = string;
        this.initShim = null;
    }

    @Override
    @Deprecated
    public Locale getLocale() {
        return this.initShim != null ? this.initShim.getLocale() : this.locale;
    }

    @Override
    @Deprecated
    public String getString() {
        return this.initShim != null ? this.initShim.getString() : this.string;
    }

    @Deprecated
    public final LocalizedString withLocale(Locale value) {
        if (this.locale == value) {
            return this;
        }
        Locale newValue = (Locale)Preconditions.checkNotNull((Object)value);
        return LocalizedString.validate(new LocalizedString(this, newValue, this.string));
    }

    @Deprecated
    public final LocalizedString withString(String value) {
        if (this.string == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return LocalizedString.validate(new LocalizedString(this, this.locale, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LocalizedString && this.equalTo((LocalizedString)another);
    }

    private boolean equalTo(LocalizedString another) {
        return this.locale.equals(another.locale) && this.string.equals(another.string);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.locale.hashCode();
        h = h * 17 + this.string.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LocalizedString").add("locale", (Object)this.locale).add("string", (Object)this.string).toString();
    }

    public static LocalizedString of() {
        return INSTANCE;
    }

    public static LocalizedString of(Locale locale, String string) {
        return LocalizedString.validate(new LocalizedString(locale, string));
    }

    private static LocalizedString validate(LocalizedString instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static LocalizedString copyOf(LocalizedString instance) {
        if (instance instanceof LocalizedString) {
            return instance;
        }
        return LocalizedString.of(instance.getLocale(), instance.getString());
    }

    private Object readResolve() throws ObjectStreamException {
        return LocalizedString.validate(this);
    }

    private final class InitShim {
        private Locale locale;
        private byte localeStage;
        private String string;
        private byte stringStage;

        private InitShim() {
        }

        Locale getLocale() {
            if (this.localeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.localeStage == 0) {
                this.localeStage = (byte)-1;
                this.locale = (Locale)Preconditions.checkNotNull((Object)LocalizedString.super.getLocale());
                this.localeStage = 1;
            }
            return this.locale;
        }

        Locale setLocale(Locale value) {
            this.locale = value;
            this.localeStage = 1;
            return value;
        }

        String getString() {
            if (this.stringStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stringStage == 0) {
                this.stringStage = (byte)-1;
                this.string = (String)Preconditions.checkNotNull((Object)LocalizedString.super.getString());
                this.stringStage = 1;
            }
            return this.string;
        }

        String setString(String value) {
            this.string = value;
            this.stringStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.localeStage == -1) {
                attributes.add("locale");
            }
            if (this.stringStage == -1) {
                attributes.add("string");
            }
            return "Cannot build LocalizedString, attribute initializers form cycle" + attributes;
        }
    }
}

