/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import eu.trentorise.opendata.commons.LocalizedString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class Dict
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Dict INSTANCE = new Dict();
    private static final int PADDING = 10;
    private ImmutableListMultimap<Locale, String> strings;

    private Dict() {
        this.strings = ImmutableListMultimap.of();
    }

    public static Dict of() {
        return INSTANCE;
    }

    public static Dict of(Locale locale, String ... strings) {
        Dict ret = new Dict();
        ret.strings = ImmutableListMultimap.builder().putAll((Object)locale, (Object[])strings).build();
        return ret;
    }

    public ImmutableListMultimap<Locale, String> asMultimap() {
        return this.strings;
    }

    public static Dict of(String ... strings) {
        return Dict.of(Locale.ROOT, strings);
    }

    public static Dict of(Iterable<String> strings) {
        return Dict.of(Locale.ROOT, strings);
    }

    public static Dict of(Locale locale, Iterable<String> strings) {
        Dict ret = new Dict();
        ret.strings = ImmutableListMultimap.builder().putAll((Object)locale, strings).build();
        return ret;
    }

    public static Dict of(LocalizedString localizedString) {
        return Dict.of(localizedString.loc(), localizedString.str());
    }

    private Dict(Builder dictBuilder) {
        this.strings = dictBuilder.stringsBuilder.build();
    }

    public ImmutableList<String> get(Locale locale) {
        return this.strings.get((Object)locale);
    }

    public ImmutableList<String> strings(Locale locale) {
        return this.strings.get((Object)locale);
    }

    public String str(Locale locale) {
        ImmutableList<String> rets = this.strings(locale);
        if (rets.isEmpty()) {
            return "";
        }
        return (String)rets.get(0);
    }

    public String string(Locale locale) {
        return this.str(locale);
    }

    public boolean isEmpty() {
        for (Locale locale : this.locales()) {
            String t = this.nonEmptyString(locale);
            if (t.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ImmutableSet<Locale> locales() {
        return this.strings.keySet();
    }

    public boolean contains(String text) {
        Preconditions.checkNotNull((Object)text);
        for (Locale loc : this.locales()) {
            String lowText = text.toLowerCase(loc);
            for (String t : this.strings.get((Object)loc)) {
                if (!t.toLowerCase(loc).contains(lowText)) continue;
                return true;
            }
        }
        return false;
    }

    public String nonEmptyString(Locale locale) {
        Preconditions.checkNotNull((Object)locale);
        for (String s : this.strings(locale)) {
            if (s.isEmpty()) continue;
            return s;
        }
        return "";
    }

    public LocalizedString anyString(Iterable<Locale> locales) {
        return this.some(locales);
    }

    public LocalizedString some(Locale ... locales) {
        return this.some(Arrays.asList(locales));
    }

    public LocalizedString some(Iterable<Locale> locales) {
        Preconditions.checkNotNull(locales);
        for (Locale loc : locales) {
            Preconditions.checkNotNull((Object)loc);
            String t = this.nonEmptyString(loc);
            if (t.isEmpty()) continue;
            return LocalizedString.of(loc, t);
        }
        String t = this.nonEmptyString(Locale.ENGLISH);
        if (!t.isEmpty()) {
            return LocalizedString.of(Locale.ENGLISH, t);
        }
        for (Locale loc : this.locales()) {
            String other = this.nonEmptyString(loc);
            if (other.isEmpty()) continue;
            return LocalizedString.of(loc, other);
        }
        return LocalizedString.of();
    }

    public LocalizedString anyString(Locale ... locales) {
        return this.some(locales);
    }

    public Dict with(Locale locale, String ... strings) {
        return Dict.builder().put(this).put(locale, strings).build();
    }

    public Dict with(String ... strings) {
        return Dict.builder().put(this).put(Locale.ROOT, strings).build();
    }

    public Dict with(Locale locale, Iterable<String> strings) {
        return Dict.builder().put(this).put(locale, strings).build();
    }

    public Dict with(Dict dict) {
        return Dict.builder().put(this).put(dict).build();
    }

    private static String padLeft(String msg, int maxLength) {
        Preconditions.checkNotNull((Object)msg);
        String nmot = msg.length() > maxLength ? msg.substring(0, msg.length() - 3) + "..." : String.format("%" + maxLength + "s", msg);
        return nmot;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.strings != null ? this.strings.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dict other = (Dict)obj;
        return this.strings == other.strings || this.strings != null && this.strings.equals(other.strings);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("{\n");
        for (Locale loc : this.strings.keySet()) {
            sb.append(Dict.padLeft(loc.toString(), 10)).append(": [");
            boolean first = true;
            for (String t : this.strings.get((Object)loc)) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(t);
            }
            sb.append("]\n");
        }
        sb.append("}\n");
        sb.append("\n");
        return sb.toString();
    }

    public static Dict of(Multimap<Locale, String> multimap) {
        Dict ret = new Dict();
        ret.strings = ImmutableListMultimap.copyOf(multimap);
        return ret;
    }

    public static Dict ofDicts(Dict ... dicts) {
        return Dict.ofDicts(Arrays.asList(dicts));
    }

    public static Dict ofDicts(Iterable<Dict> dicts) {
        Builder retb = Dict.builder();
        for (Dict st : dicts) {
            retb.put(st);
        }
        return retb.build();
    }

    public static Dict ofLocalizedStrings(Iterable<LocalizedString> localizedStrings) {
        Builder dictb = Dict.builder();
        for (LocalizedString st : localizedStrings) {
            dictb.put(st.loc(), st.str());
        }
        return dictb.build();
    }

    public ImmutableList<LocalizedString> asLocalizedStrings() {
        ImmutableList.Builder retb = ImmutableList.builder();
        for (Locale locale : this.locales()) {
            for (String s : this.get(locale)) {
                retb.add((Object)LocalizedString.of(locale, s));
            }
        }
        return retb.build();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableListMultimap.Builder<Locale, String> stringsBuilder = ImmutableListMultimap.builder();

        private Builder() {
        }

        public Builder put(Locale locale, String ... strings) {
            this.stringsBuilder.putAll((Object)locale, (Object[])strings);
            return this;
        }

        public Dict build() {
            return new Dict(this);
        }

        public Builder put(Locale locale, Iterable<String> strings) {
            this.stringsBuilder.putAll((Object)locale, strings);
            return this;
        }

        public Builder put(String ... strings) {
            this.stringsBuilder.putAll((Object)Locale.ROOT, (Object[])strings);
            return this;
        }

        public Builder put(Dict dict) {
            this.stringsBuilder.putAll((Multimap)dict.strings);
            return this;
        }
    }
}

