/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.jaxb.helper;

import eu.openaire.oaf.model.base.FundingTreeType;
import eu.openaire.oaf.model.base.NamedIdElementType;
import eu.openaire.oaf.model.base.QualifierType;
import eu.openaire.oaf.model.base.RelsType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;

public class ProjectHelper {
    private Map<String, Collection<String>> stringTypeProperties = new HashMap<String, Collection<String>>();
    private Map<String, Collection<FundingTreeType>> fundingTreeTypeProperties = new HashMap<String, Collection<FundingTreeType>>();
    private Map<String, Collection<NamedIdElementType>> namedIdElementTypeProperties = new HashMap<String, Collection<NamedIdElementType>>();
    private Map<String, Collection<QualifierType>> qualifierTypeProperties = new HashMap<String, Collection<QualifierType>>();
    private Map<String, Collection<Boolean>> booleanTypeProperties = new HashMap<String, Collection<Boolean>>();
    private Map<String, Collection<RelsType>> relsTypeProperties = new HashMap<String, Collection<RelsType>>();

    public ProjectHelper(List<JAXBElement<? extends Serializable>> projectProperties) {
        for (JAXBElement<? extends Serializable> element : projectProperties) {
            String nodeName = element.getName().getLocalPart();
            String nodeType = element.getDeclaredType().getSimpleName();
            Object castValue = element.getDeclaredType().cast(element.getValue());
            switch (nodeType) {
                case "String": {
                    Collection stringCollection = this.stringTypeProperties.getOrDefault(nodeName, new ArrayList());
                    stringCollection.add((String)castValue);
                    this.stringTypeProperties.put(nodeName, stringCollection);
                    break;
                }
                case "FundingTreeType": {
                    Collection fundingTreeTypeCollection = this.fundingTreeTypeProperties.getOrDefault(nodeName, new ArrayList());
                    fundingTreeTypeCollection.add((FundingTreeType)castValue);
                    this.fundingTreeTypeProperties.put(nodeName, fundingTreeTypeCollection);
                    break;
                }
                case "NamedIdElementType": {
                    Collection namedIdElementTypeCollection = this.namedIdElementTypeProperties.getOrDefault(nodeName, new ArrayList());
                    namedIdElementTypeCollection.add((NamedIdElementType)castValue);
                    this.namedIdElementTypeProperties.put(nodeName, namedIdElementTypeCollection);
                    break;
                }
                case "QualifierType": {
                    Collection qualifierTypeCollection = this.qualifierTypeProperties.getOrDefault(nodeName, new ArrayList());
                    qualifierTypeCollection.add((QualifierType)castValue);
                    this.qualifierTypeProperties.put(nodeName, qualifierTypeCollection);
                    break;
                }
                case "Boolean": {
                    Collection booleanTypeCollection = this.booleanTypeProperties.getOrDefault(nodeName, new ArrayList());
                    booleanTypeCollection.add((Boolean)castValue);
                    this.booleanTypeProperties.put(nodeName, booleanTypeCollection);
                    break;
                }
                case "RelsType": {
                    Collection relsTypeCollection = this.relsTypeProperties.getOrDefault(nodeName, new ArrayList());
                    relsTypeCollection.add((RelsType)castValue);
                    this.relsTypeProperties.put(nodeName, relsTypeCollection);
                }
            }
        }
    }

    public Collection<String> getCodes() {
        return this.getStringValue("code");
    }

    public Collection<String> getAcronyms() {
        return this.getStringValue("acronym");
    }

    public Collection<String> getCallIdentifiers() {
        return this.getStringValue("callidentifier");
    }

    public Collection<String> getTitles() {
        return this.getStringValue("title");
    }

    public Collection<String> getStartDates() {
        return this.getStringValue("startdate");
    }

    public Collection<String> getDurations() {
        return this.getStringValue("duration");
    }

    public Collection<String> getEndDates() {
        return this.getStringValue("enddate");
    }

    public Collection<String> getOriginalIds() {
        return this.getStringValue("originalId");
    }

    public Collection<String> getContactFullNames() {
        return this.getStringValue("contactfullname");
    }

    public Collection<String> getContactFaxes() {
        return this.getStringValue("contactfax");
    }

    public Collection<String> getContactPhones() {
        return this.getStringValue("contactphone");
    }

    public Collection<String> getContactEmails() {
        return this.getStringValue("contactemail");
    }

    public Collection<String> getKeywords() {
        return this.getStringValue("keywords");
    }

    public Collection<String> getWebsiteUrls() {
        return this.getStringValue("websiteurl");
    }

    public Collection<String> getECArticle29_3s() {
        return this.getStringValue("ecarticle29_3");
    }

    public Collection<String> getECSc39s() {
        return this.getStringValue("ecsc39");
    }

    public Collection<Boolean> getOAMandatePublications() {
        return this.getBooleanValue("oamandatepublications");
    }

    public Collection<FundingTreeType> getFundingTreeTypes() {
        return this.getFundingTypeValue("fundingtree");
    }

    public Collection<RelsType> getRels() {
        return this.getRelsTypeValue("rels");
    }

    public Collection<QualifierType> getContractTypes() {
        return this.getQualifierTypeValue("contracttype");
    }

    public Collection<QualifierType> getSubjects() {
        return this.getQualifierTypeValue("subjects");
    }

    public Collection<QualifierType> getPids() {
        return this.getQualifierTypeValue("pid");
    }

    public Collection<NamedIdElementType> getCollectedFroms() {
        return this.getNamedIdElementTypeValue("collectedfrom");
    }

    private Collection<String> getStringValue(String fieldName) {
        return this.stringTypeProperties.getOrDefault(fieldName, new ArrayList());
    }

    private Collection<FundingTreeType> getFundingTypeValue(String fieldName) {
        return this.fundingTreeTypeProperties.getOrDefault(fieldName, new ArrayList());
    }

    private Collection<NamedIdElementType> getNamedIdElementTypeValue(String fieldName) {
        return this.namedIdElementTypeProperties.getOrDefault(fieldName, new ArrayList());
    }

    private Collection<QualifierType> getQualifierTypeValue(String fieldName) {
        return this.qualifierTypeProperties.getOrDefault(fieldName, new ArrayList());
    }

    private Collection<Boolean> getBooleanValue(String fieldName) {
        return this.booleanTypeProperties.getOrDefault(fieldName, new ArrayList());
    }

    private Collection<RelsType> getRelsTypeValue(String fieldName) {
        return this.relsTypeProperties.getOrDefault(fieldName, new ArrayList());
    }
}

