/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.extensions.mmr;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.extensions.mmr.ModelRequest;
import eu.maveniverse.maven.mima.extensions.mmr.ModelResponse;
import eu.maveniverse.maven.mima.extensions.mmr.internal.MavenModelReaderImpl;
import java.util.Objects;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.interpolation.StringVisitorModelInterpolator;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenModelReader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Context context;
    private final MavenModelReaderImpl mavenModelReaderImpl;

    public MavenModelReader(Context context) {
        this.context = Objects.requireNonNull(context);
        this.mavenModelReaderImpl = new MavenModelReaderImpl(context.repositorySystem(), (RemoteRepositoryManager)context.lookup().lookup(RemoteRepositoryManager.class).orElseThrow(() -> new IllegalStateException("RemoteRepositoryManager not available")), (RepositoryEventDispatcher)context.lookup().lookup(RepositoryEventDispatcher.class).orElseThrow(() -> new IllegalStateException("RepositoryEventDispatcher not available")), (ModelBuilder)context.lookup().lookup(ModelBuilder.class).orElseThrow(() -> new IllegalStateException("ModelBuilder not available")), (StringVisitorModelInterpolator)context.lookup().lookup(StringVisitorModelInterpolator.class).orElseThrow(() -> new IllegalStateException("StringVisitorModelInterpolator not available")), context.remoteRepositories());
    }

    public ModelResponse readModel(ModelRequest request) throws VersionResolutionException, ArtifactResolutionException, ArtifactDescriptorException {
        Objects.requireNonNull(request, "request");
        return this.mavenModelReaderImpl.readModel(this.context.repositorySystemSession(), request);
    }

    public MavenModelReaderImpl getImpl() {
        return this.mavenModelReaderImpl;
    }
}

