/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationCalculator;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServiceFilter;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueServiceFilter
implements TrustServiceFilter {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueServiceFilter.class);
    private final CertificateWrapper endEntityCert;

    public UniqueServiceFilter(CertificateWrapper endEntityCert) {
        this.endEntityCert = endEntityCert;
    }

    @Override
    public List<TrustServiceWrapper> filter(List<TrustServiceWrapper> trustServices) {
        TrustServiceWrapper selectedTrustService = null;
        if (Utils.collectionSize(trustServices) == 1) {
            selectedTrustService = trustServices.get(0);
        } else if (Utils.isCollectionNotEmpty(trustServices)) {
            LOG.info("More than one selected trust services");
            EnumMap<CertificateQualification, List> qualificationResults = new EnumMap<CertificateQualification, List>(CertificateQualification.class);
            for (TrustServiceWrapper trustService : trustServices) {
                CertificateQualificationCalculator calculator = new CertificateQualificationCalculator(this.endEntityCert, trustService);
                CertificateQualification certQualification = calculator.getQualification();
                if (qualificationResults.containsKey(certQualification)) continue;
                qualificationResults.put(certQualification, trustService.getServiceNames());
            }
            if (qualificationResults.size() > 1) {
                LOG.warn("Unable to select the trust service ! Several possible conclusions {}", qualificationResults);
            } else {
                LOG.info("All trust services conclude with the same result");
                selectedTrustService = trustServices.get(0);
            }
        }
        if (selectedTrustService != null) {
            return Collections.singletonList(selectedTrustService);
        }
        return Collections.emptyList();
    }
}

