/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;

public class EncryptionAlgorithmReliableCheck
extends AbstractCryptographicCheck {
    private final EncryptionAlgorithm encryptionAlgo;
    private final CryptographicConstraintWrapper constraintWrapper;

    protected EncryptionAlgorithmReliableCheck(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgo, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper.getAcceptableEncryptionAlgoLevel());
        this.encryptionAlgo = encryptionAlgo;
        this.constraintWrapper = constraintWrapper;
    }

    @Override
    protected boolean process() {
        return this.constraintWrapper.isEncryptionAlgorithmReliable(this.encryptionAlgo);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_EAA, this.getName(this.encryptionAlgo));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_EAA_ANS, this.getName(this.encryptionAlgo), this.position);
    }
}

