/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.fc.AbstractFormatChecking;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AllFilesSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.EllipticCurveKeySizeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FormatCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FullScopeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ReferencesNotAmbiguousCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignatureNotAmbiguousCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignerInformationStoreCheck;

public class SignatureFormatChecking
extends AbstractFormatChecking<SignatureWrapper> {
    public SignatureFormatChecking(I18nProvider i18nProvider, DiagnosticData diagnosticData, SignatureWrapper signature, Context context, ValidationPolicy policy) {
        super(i18nProvider, diagnosticData, signature, context, policy);
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.FORMAT_CHECKING;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlFC> item = this.firstItem = this.formatCheck();
        item = item.setNextItem(this.signatureDuplicateCheck());
        item = item.setNextItem(this.referenceDuplicateCheck());
        item = item.setNextItem(this.fullScopeCheck());
        if (((SignatureWrapper)this.token).getPDFRevision() != null) {
            item = item.setNextItem(this.signerInformationStoreCheck());
            item = this.getPDFRevisionValidationChain(item);
        }
        if (this.diagnosticData.isPDFAValidationPerformed()) {
            item = this.getPdfaValidationChain(item);
        }
        if (SignatureForm.JAdES.equals((Object)((SignatureWrapper)this.token).getSignatureFormat().getSignatureForm()) && ((SignatureWrapper)this.token).getEncryptionAlgorithm() != null && ((SignatureWrapper)this.token).getEncryptionAlgorithm().isEquivalent(EncryptionAlgorithm.ECDSA)) {
            item = item.setNextItem(this.ellipticCurveKeySizeCheck());
        }
        if (this.diagnosticData.isContainerInfoPresent()) {
            item = this.getASiCContainerValidationChain(item);
            item = item.setNextItem(this.allFilesSignedCheck());
        }
    }

    private ChainItem<XmlFC> formatCheck() {
        MultiValuesConstraint constraint = this.policy.getSignatureFormatConstraint(this.context);
        return new FormatCheck(this.i18nProvider, (XmlFC)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlFC> signatureDuplicateCheck() {
        LevelConstraint constraint = this.policy.getSignatureDuplicatedConstraint(this.context);
        return new SignatureNotAmbiguousCheck(this.i18nProvider, (XmlFC)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlFC> referenceDuplicateCheck() {
        return new ReferencesNotAmbiguousCheck(this.i18nProvider, (XmlFC)this.result, (SignatureWrapper)this.token, this.getFailLevelConstraint());
    }

    private ChainItem<XmlFC> fullScopeCheck() {
        LevelConstraint constraint = this.policy.getFullScopeConstraint();
        return new FullScopeCheck(this.i18nProvider, (XmlFC)this.result, ((SignatureWrapper)this.token).getSignatureScopes(), constraint);
    }

    private ChainItem<XmlFC> signerInformationStoreCheck() {
        LevelConstraint constraint = this.policy.getSignerInformationStoreConstraint(this.context);
        return new SignerInformationStoreCheck(this.i18nProvider, (XmlFC)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlFC> ellipticCurveKeySizeCheck() {
        LevelConstraint constraint = this.policy.getEllipticCurveKeySizeConstraint(this.context);
        return new EllipticCurveKeySizeCheck(this.i18nProvider, (XmlFC)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlFC> allFilesSignedCheck() {
        LevelConstraint constraint = this.policy.getAllFilesSignedConstraint();
        return new AllFilesSignedCheck(this.i18nProvider, (XmlFC)this.result, (SignatureWrapper)this.token, this.diagnosticData.getContainerInfo(), constraint);
    }
}

