/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;

public class ReferenceDataIntactCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final XmlDigestMatcher digestMatcher;

    public ReferenceDataIntactCheck(I18nProvider i18nProvider, T result, XmlDigestMatcher digestMatcher, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.digestMatcher = digestMatcher;
    }

    @Override
    protected boolean process() {
        return this.digestMatcher.isDataIntact();
    }

    @Override
    protected MessageTag getMessageTag() {
        switch (this.digestMatcher.getType()) {
            case MESSAGE_IMPRINT: {
                return MessageTag.BBB_CV_TSP_IRDOI;
            }
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.BBB_CV_CS_CSPS;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP: {
                return MessageTag.BBB_CV_ER_ATSRI;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE: {
                return MessageTag.BBB_CV_ER_ATSSRI;
            }
        }
        return MessageTag.BBB_CV_IRDOI;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.digestMatcher.getType()) {
            case MESSAGE_IMPRINT: {
                return MessageTag.BBB_CV_TSP_IRDOI_ANS;
            }
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.BBB_CV_CS_CSPS_ANS;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP: {
                return MessageTag.BBB_CV_ER_ATSRI_ANS;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE: {
                return MessageTag.BBB_CV_ER_ATSSRI_ANS;
            }
        }
        return MessageTag.BBB_CV_IRDOI_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.HASH_FAILURE;
    }

    @Override
    protected String buildAdditionalInfo() {
        Object referenceName;
        switch (this.digestMatcher.getType()) {
            case MESSAGE_IMPRINT: 
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return null;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP: {
                referenceName = MessageTag.TST_TYPE_REF_ER_ATST;
                break;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE: {
                referenceName = MessageTag.TST_TYPE_REF_ER_ATST_SEQ;
                break;
            }
            default: {
                referenceName = Utils.isStringNotBlank((String)this.digestMatcher.getName()) ? this.digestMatcher.getName() : this.digestMatcher.getType().name();
            }
        }
        return this.i18nProvider.getMessage(MessageTag.REFERENCE, new Object[]{referenceName});
    }
}

