/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xml.utils;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.SantuarioInitializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class XMLCanonicalizer {
    private static final Logger LOG = LoggerFactory.getLogger(XMLCanonicalizer.class);
    private static final Set<String> canonicalizers;
    public static final String DEFAULT_DSS_C14N_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String DEFAULT_XMLDSIG_C14N_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private final Canonicalizer c14n;

    private static void registerDefaultCanonicalizers() {
        XMLCanonicalizer.registerCanonicalizer(DEFAULT_XMLDSIG_C14N_METHOD);
        XMLCanonicalizer.registerCanonicalizer(DEFAULT_DSS_C14N_METHOD);
        XMLCanonicalizer.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11");
        XMLCanonicalizer.registerCanonicalizer("http://santuario.apache.org/c14n/physical");
        XMLCanonicalizer.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        XMLCanonicalizer.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        XMLCanonicalizer.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11#WithComments");
    }

    private XMLCanonicalizer(String canonicalizationMethod) {
        canonicalizationMethod = XMLCanonicalizer.getCanonicalizationMethod(canonicalizationMethod);
        XMLCanonicalizer.assertCanonicalizationMethodSupported(canonicalizationMethod);
        this.c14n = XMLCanonicalizer.initCanonicalizer(canonicalizationMethod);
    }

    public static XMLCanonicalizer createInstance() {
        return XMLCanonicalizer.createInstance(null);
    }

    public static XMLCanonicalizer createInstance(String canonicalizationMethod) {
        return new XMLCanonicalizer(canonicalizationMethod);
    }

    private static void assertCanonicalizationMethodSupported(String canonicalizationMethod) {
        if (!XMLCanonicalizer.canCanonicalize(canonicalizationMethod)) {
            throw new IllegalArgumentException(String.format("The canonicalization method '{}' is not supported! Use #registerCanonicalizer method to add support of a canonicalization method.", canonicalizationMethod));
        }
    }

    private static Canonicalizer initCanonicalizer(String canonicalizationMethod) {
        try {
            return Canonicalizer.getInstance((String)canonicalizationMethod);
        }
        catch (InvalidCanonicalizerException e) {
            throw new DSSException(String.format("The canonicalizer cannot be instantiated with canonicalization method '%s'! Reason : %s", canonicalizationMethod, e.getMessage()), (Throwable)e);
        }
    }

    public static boolean canCanonicalize(String canonicalizationMethod) {
        return canonicalizers.contains(canonicalizationMethod);
    }

    public static boolean registerCanonicalizer(String c14nAlgorithmURI) {
        return canonicalizers.add(c14nAlgorithmURI);
    }

    public byte[] canonicalize(InputStream inputStream) {
        byte[] byArray;
        block8: {
            InputStream is = inputStream;
            try {
                byArray = this.canonicalize(DomUtils.buildDOM(is));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException("Error on InputStream processing", (Throwable)e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public void canonicalize(InputStream inputStream, OutputStream outputStream) {
        try (InputStream is = inputStream;){
            this.canonicalize(DomUtils.buildDOM(is), outputStream);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the InputStream", (Throwable)e);
        }
    }

    public byte[] canonicalize(byte[] toCanonicalizeBytes) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.canonicalize(toCanonicalizeBytes, (OutputStream)baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error on ByteArrayOutputStream processing", (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    public void canonicalize(byte[] toCanonicalizeBytes, OutputStream outputStream) {
        try {
            this.c14n.canonicalize(toCanonicalizeBytes, outputStream, true);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the binaries", (Throwable)e);
        }
    }

    public byte[] canonicalize(Node node) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.canonicalize(node, (OutputStream)baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error on ByteArrayOutputStream processing", (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    public void canonicalize(Node node, OutputStream outputStream) {
        try {
            this.c14n.canonicalizeSubtree(node, outputStream);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the subtree", (Throwable)e);
        }
    }

    private static String getCanonicalizationMethod(String canonicalizationMethod) {
        if (Utils.isStringEmpty((String)canonicalizationMethod)) {
            LOG.warn("Canonicalization method is not defined. An inclusive canonicalization '{}' will be used (see XMLDSIG 4.4.3.2).", (Object)DEFAULT_XMLDSIG_C14N_METHOD);
            return DEFAULT_XMLDSIG_C14N_METHOD;
        }
        return canonicalizationMethod;
    }

    static {
        SantuarioInitializer.init();
        canonicalizers = new HashSet<String>();
        XMLCanonicalizer.registerDefaultCanonicalizers();
    }
}

