/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xml.common;

import eu.europa.esig.dss.xml.common.AbstractFactoryBuilder;
import eu.europa.esig.dss.xml.common.exception.SecurityConfigurationException;
import javax.xml.validation.SchemaFactory;

public class SchemaFactoryBuilder
extends AbstractFactoryBuilder<SchemaFactory> {
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";

    protected SchemaFactoryBuilder() {
        this.enableFeature("http://javax.xml.XMLConstants/feature/secure-processing");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }

    public static SchemaFactoryBuilder getSecureSchemaBuilder() {
        return new SchemaFactoryBuilder();
    }

    public SchemaFactory build() {
        SchemaFactory sf = this.instantiateFactory();
        this.setSecurityFeatures(sf);
        this.setSecurityAttributes(sf);
        return sf;
    }

    @Override
    protected SchemaFactory instantiateFactory() {
        return SchemaFactory.newInstance(this.schemaLanguage);
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public SchemaFactoryBuilder enableFeature(String feature) {
        return (SchemaFactoryBuilder)super.enableFeature(feature);
    }

    public SchemaFactoryBuilder disableFeature(String feature) {
        return (SchemaFactoryBuilder)super.disableFeature(feature);
    }

    public SchemaFactoryBuilder setAttribute(String attribute, Object value) {
        return (SchemaFactoryBuilder)super.setAttribute(attribute, value);
    }

    public SchemaFactoryBuilder removeAttribute(String attribute) {
        return (SchemaFactoryBuilder)super.removeAttribute(attribute);
    }

    @Override
    protected void setSecurityFeature(SchemaFactory factory, String feature, Boolean value) throws SecurityConfigurationException {
        try {
            factory.setFeature(feature, value);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException(e);
        }
    }

    @Override
    protected void setSecurityAttribute(SchemaFactory factory, String attribute, Object value) throws SecurityConfigurationException {
        try {
            factory.setProperty(attribute, value);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException(e);
        }
    }
}

