/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidatorLoader;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Path;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Path;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Path;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.policy.XMLSignaturePolicyValidator;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentAnalyzer
extends DefaultDocumentAnalyzer {
    protected List<XAdESPath> xadesPathsHolders;
    protected Document rootElement;
    private boolean disableXSWProtection = false;

    XMLDocumentAnalyzer() {
    }

    public XMLDocumentAnalyzer(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "Document to be validated cannot be null!");
        this.document = dssDocument;
        this.rootElement = this.toDomDocument(dssDocument);
        this.xadesPathsHolders = new ArrayList<XAdESPath>();
        this.xadesPathsHolders.add(new XAdES111Path());
        this.xadesPathsHolders.add(new XAdES122Path());
        this.xadesPathsHolders.add(new XAdES132Path());
    }

    private Document toDomDocument(DSSDocument document) {
        try {
            return DomUtils.buildDOM((DSSDocument)document);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("An XML file is expected : %s", e.getMessage()), (Throwable)e);
        }
    }

    public boolean isSupported(DSSDocument dssDocument) {
        return DomUtils.startsWithXmlPreamble((DSSDocument)dssDocument) && !EvidenceRecordAnalyzerFactory.isSupportedDocument((DSSDocument)dssDocument);
    }

    public void setDisableXSWProtection(boolean disableXSWProtection) {
        this.disableXSWProtection = disableXSWProtection;
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        NodeList signatureNodeList = DSSXMLUtils.getAllSignaturesExceptCounterSignatures(this.rootElement);
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Element signatureEl = (Element)signatureNodeList.item(ii);
            Node parent = signatureEl.getParentNode();
            String nodeName = parent.getNodeName();
            String ns = parent.getNamespaceURI();
            if ("saml2:Assertion".equals(nodeName) && DSSXMLUtils.SAML_NAMESPACE.isSameUri(ns)) continue;
            XAdESSignature xadesSignature = new XAdESSignature(signatureEl, this.xadesPathsHolders);
            xadesSignature.setFilename(this.document.getName());
            xadesSignature.setDetachedContents(this.detachedContents);
            xadesSignature.setContainerContents(this.containerContents);
            xadesSignature.setSigningCertificateSource(this.signingCertificateSource);
            xadesSignature.setDisableXSWProtection(this.disableXSWProtection);
            xadesSignature.initBaselineRequirementsChecker(this.certificateVerifier);
            this.validateSignaturePolicy((AdvancedSignature)xadesSignature);
            signatures.add((AdvancedSignature)xadesSignature);
        }
        return signatures;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        XAdESSignature signature = (XAdESSignature)advancedSignature;
        return XAdESSignatureUtils.getSignerDocuments(signature);
    }

    public List<XAdESPath> getXAdESPathsHolder() {
        return this.xadesPathsHolders;
    }

    public void addXAdESPathsHolder(XAdESPath xadesPathsHolder) {
        this.xadesPathsHolders.add(xadesPathsHolder);
    }

    public void clearQueryHolders() {
        this.xadesPathsHolders.clear();
    }

    public Document getRootElement() {
        return this.rootElement;
    }

    public SignaturePolicyValidatorLoader getSignaturePolicyValidatorLoader() {
        DefaultSignaturePolicyValidatorLoader signaturePolicyValidatorLoader = new DefaultSignaturePolicyValidatorLoader();
        signaturePolicyValidatorLoader.setDefaultSignaturePolicyValidator((SignaturePolicyValidator)new XMLSignaturePolicyValidator());
        return signaturePolicyValidatorLoader;
    }

    static {
        DSSXMLUtils.registerXAdESNamespaces();
    }
}

