/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.ValidationDataEncapsulationStrategy;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLT
extends XAdESLevelBaselineT {
    public XAdESLevelBaselineLT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        List<AdvancedSignature> signaturesToExtend = this.getExtendToLTLevelSignatures(signatures);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return;
        }
        for (AdvancedSignature signature : signaturesToExtend) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            this.xadesSignature.resetCertificateSource();
            this.xadesSignature.resetRevocationSources();
            this.xadesSignature.resetTimestampSource();
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker();
        if (SignatureLevel.XAdES_BASELINE_LT.equals((Object)this.params.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToLTLevelPossible(signaturesToExtend);
        }
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertCertificateChainValidForLTLevel(signaturesToExtend);
        ValidationDataContainer validationDataContainer = this.documentAnalyzer.getValidationData(signaturesToExtend);
        for (AdvancedSignature signature : signaturesToExtend) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (signatureRequirementsChecker.hasLTALevelOrHigher(signature)) continue;
            String indent = this.removeOldCertificateValues();
            this.removeOldRevocationValues();
            String anyDataIndent = this.removeLastTimestampAndAnyValidationData();
            if (indent == null) {
                indent = anyDataIndent;
            }
            Element levelTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            ValidationData includedValidationData = this.incorporateValidationDataForSignature(validationDataContainer, signature, indent);
            this.incorporateValidationDataForTimestamps(validationDataContainer, signature, indent, includedValidationData);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelTUnsignedProperties);
        }
    }

    protected ValidationDataEncapsulationStrategy getValidationDataEncapsulationStrategy() {
        if (this.params.isEn319132()) {
            return this.params.getValidationDataEncapsulationStrategy();
        }
        return ValidationDataEncapsulationStrategy.CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA;
    }

    private ValidationData incorporateValidationDataForSignature(ValidationDataContainer validationDataContainer, AdvancedSignature signature, String indent) {
        ValidationData validationDataForInclusion;
        ValidationDataEncapsulationStrategy validationDataEncapsulationStrategy = this.getValidationDataEncapsulationStrategy();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case ANY_VALIDATION_DATA_ONLY: {
                validationDataForInclusion = validationDataContainer.getAllValidationDataForSignatureForInclusion(signature);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: {
                validationDataForInclusion = validationDataContainer.getValidationDataForSignatureForInclusion(signature);
                validationDataForInclusion.addValidationData(validationDataContainer.getValidationDataForCounterSignaturesForInclusion(signature));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", validationDataEncapsulationStrategy));
            }
        }
        Set certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
        Set crlsToAdd = validationDataForInclusion.getCrlTokens();
        Set ocspsToAdd = validationDataForInclusion.getOcspTokens();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: 
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: 
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: {
                this.incorporateCertificateValues(this.unsignedSignaturePropertiesDom, certificateValuesToAdd, indent);
                this.incorporateRevocationValues(this.unsignedSignaturePropertiesDom, crlsToAdd, ocspsToAdd, indent);
                break;
            }
            case ANY_VALIDATION_DATA_ONLY: {
                this.incorporateAnyValidationData(validationDataForInclusion, indent);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", validationDataEncapsulationStrategy));
            }
        }
        return validationDataForInclusion;
    }

    private void incorporateValidationDataForTimestamps(ValidationDataContainer validationDataContainer, AdvancedSignature signature, String indent, ValidationData validationDataToExclude) {
        ValidationDataEncapsulationStrategy validationDataEncapsulationStrategy = this.getValidationDataEncapsulationStrategy();
        switch (validationDataEncapsulationStrategy) {
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_LT_SEPARATED: {
                ValidationData validationData = validationDataContainer.getValidationDataForSignatureTimestampsForInclusion(signature);
                validationData.addValidationData(validationDataContainer.getValidationDataForCounterSignatureTimestampsForInclusion(signature));
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateTimestampValidationData(validationData, indent);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA_AND_ANY_VALIDATION_DATA: {
                ValidationData validationData = validationDataContainer.getValidationDataForSignatureTimestampsForInclusion(signature);
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateTimestampValidationData(validationData, indent);
                ValidationData counterSigTstValidationData = validationDataContainer.getValidationDataForCounterSignatureTimestampsForInclusion(signature);
                counterSigTstValidationData.excludeValidationData(validationData);
                counterSigTstValidationData.excludeValidationData(validationDataToExclude);
                this.incorporateAnyValidationData(counterSigTstValidationData, indent);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_ANY_VALIDATION_DATA: {
                ValidationData validationData = validationDataContainer.getValidationDataForSignatureTimestampsForInclusion(signature);
                validationData.addValidationData(validationDataContainer.getValidationDataForCounterSignatureTimestampsForInclusion(signature));
                validationData.excludeValidationData(validationDataToExclude);
                this.incorporateAnyValidationData(validationData, indent);
                break;
            }
            case CERTIFICATE_REVOCATION_VALUES_AND_TIMESTAMP_VALIDATION_DATA: 
            case ANY_VALIDATION_DATA_ONLY: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The ValidationDataEncapsulationStrategy '%s' is not supported!", validationDataEncapsulationStrategy));
            }
        }
    }

    private List<AdvancedSignature> getExtendToLTLevelSignatures(List<AdvancedSignature> signatures) {
        ArrayList<AdvancedSignature> toBeExtended = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!this.ltLevelExtensionRequired(signature)) continue;
            toBeExtended.add(signature);
        }
        return toBeExtended;
    }

    private boolean ltLevelExtensionRequired(AdvancedSignature signature) {
        return SignatureLevel.XAdES_BASELINE_LT.equals((Object)this.params.getSignatureLevel()) || !signature.hasLTAProfile();
    }
}

