/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.timestamp;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.tsp.TimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampInclude;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureAttribute;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.validation.timestamp.SignatureTimestampIdentifierBuilder;
import eu.europa.esig.dss.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESCertificateRefExtractionUtils;
import eu.europa.esig.dss.xades.validation.XAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESSignedDataObjectProperties;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import eu.europa.esig.dss.xades.validation.scope.XAdESTimestampScopeFinder;
import eu.europa.esig.dss.xades.validation.timestamp.XAdESTimestampMessageDigestBuilder;
import eu.europa.esig.xades.definition.XAdESNamespace;
import eu.europa.esig.xades.definition.XAdESPath;
import eu.europa.esig.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.xades.definition.xadesen.XAdESENElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESTimestampSource
extends SignatureTimestampSource<XAdESSignature, XAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESTimestampSource.class);
    private final transient Element signatureElement;
    private final XAdESPath xadesPaths;
    private final Map<TimestampToken, XAdESAttribute> timestampAttributeMap = new HashMap<TimestampToken, XAdESAttribute>();

    public XAdESTimestampSource(XAdESSignature signature) {
        super((AdvancedSignature)signature);
        this.signatureElement = signature.getSignatureElement();
        this.xadesPaths = signature.getXAdESPaths();
    }

    protected SignatureProperties<XAdESAttribute> buildSignedSignatureProperties() {
        return XAdESSignedDataObjectProperties.build(this.signatureElement, this.xadesPaths);
    }

    protected SignatureProperties<XAdESAttribute> buildUnsignedSignatureProperties() {
        return XAdESUnsignedSigProperties.build(this.signatureElement, this.xadesPaths);
    }

    protected XAdESTimestampMessageDigestBuilder getTimestampMessageImprintDigestBuilder(DigestAlgorithm digestAlgorithm) {
        return new XAdESTimestampMessageDigestBuilder((XAdESSignature)this.signature, digestAlgorithm);
    }

    protected XAdESTimestampMessageDigestBuilder getTimestampMessageImprintDigestBuilder(TimestampToken timestampToken) {
        return new XAdESTimestampMessageDigestBuilder((XAdESSignature)this.signature, timestampToken).setTimestampAttribute(this.timestampAttributeMap.get(timestampToken));
    }

    public DSSMessageDigest getSignatureTimestampMessageDigest(DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        XAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod);
        return builder.getSignatureTimestampMessageDigest();
    }

    public DSSMessageDigest getTimestampX1MessageDigest(DigestAlgorithm digestAlgorithm, String canonicalizationMethod, boolean en319132) {
        XAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod).setEn319132(en319132);
        return builder.getTimestampX1MessageDigest();
    }

    public DSSMessageDigest getTimestampX2MessageDigest(DigestAlgorithm digestAlgorithm, String canonicalizationMethod, boolean en319132) {
        XAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod).setEn319132(en319132);
        return builder.getTimestampX2MessageDigest();
    }

    public DSSMessageDigest getArchiveTimestampData(DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        XAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod);
        return builder.getArchiveTimestampMessageDigest();
    }

    protected boolean isContentTimestamp(XAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isAllDataObjectsTimestamp(XAdESAttribute signedAttribute) {
        return XAdES132Element.ALL_DATA_OBJECTS_TIMESTAMP.isSameTagName(signedAttribute.getName());
    }

    protected boolean isIndividualDataObjectsTimestamp(XAdESAttribute signedAttribute) {
        return XAdES132Element.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.isSameTagName(signedAttribute.getName());
    }

    protected boolean isSignatureTimestamp(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.SIGNATURE_TIMESTAMP.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isCompleteCertificateRef(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.COMPLETE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2.isSameTagName(localName);
    }

    protected boolean isAttributeCertificateRef(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES141Element.ATTRIBUTE_CERTIFICATE_REFS_V2.isSameTagName(localName);
    }

    protected boolean isCompleteRevocationRef(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.COMPLETE_REVOCATION_REFS.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isAttributeRevocationRef(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTRIBUTE_REVOCATION_REFS.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isRefsOnlyTimestamp(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.REFS_ONLY_TIMESTAMP.isSameTagName(localName) || XAdES141Element.REFS_ONLY_TIMESTAMP_V2.isSameTagName(localName);
    }

    protected boolean isSigAndRefsTimestamp(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.SIG_AND_REFS_TIMESTAMP.isSameTagName(localName) || XAdES141Element.SIG_AND_REFS_TIMESTAMP_V2.isSameTagName(localName);
    }

    protected boolean isCertificateValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.CERTIFICATE_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isRevocationValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.REVOCATION_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isAttrAuthoritiesCertValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTR_AUTHORITIES_CERT_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isAttributeRevocationValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTRIBUTE_REVOCATION_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isArchiveTimestamp(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ARCHIVE_TIMESTAMP.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isTimeStampValidationData(XAdESAttribute unsignedAttribute) {
        return XAdES141Element.TIMESTAMP_VALIDATION_DATA.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isCounterSignature(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.COUNTER_SIGNATURE.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isSignaturePolicyStore(XAdESAttribute unsignedAttribute) {
        return XAdES141Element.SIGNATURE_POLICY_STORE.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isEvidenceRecord(XAdESAttribute unsignedAttribute) {
        return XAdESENElement.SEALING_EVIDENCE_RECORDS.isSameTagName(unsignedAttribute.getName());
    }

    protected List<TimestampToken> makeTimestampTokens(XAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        NodeList encapsulatedTimestamps = signatureAttribute.getNodeList(this.xadesPaths.getCurrentEncapsulatedTimestamp());
        if (encapsulatedTimestamps == null || encapsulatedTimestamps.getLength() == 0) {
            LOG.warn("The timestamp(s) {} cannot be extracted from the signature!", (Object)timestampType.name());
            return Collections.emptyList();
        }
        if (this.isSignatureTimestamp(signatureAttribute) && encapsulatedTimestamps.getLength() > 1) {
            LOG.warn("Only one EncapsulatedTimeStamp is allowed in '{}' element!", (Object)signatureAttribute.getName());
        }
        ArrayList<TimestampToken> result = new ArrayList<TimestampToken>();
        for (int ii = 0; ii < encapsulatedTimestamps.getLength(); ++ii) {
            Element encapsulatedTimeStamp = (Element)encapsulatedTimestamps.item(ii);
            TimestampToken timestampToken = this.createTimestampToken(encapsulatedTimeStamp, timestampType, references, signatureAttribute, ii);
            if (timestampToken == null) continue;
            timestampToken.setCanonicalizationMethod(signatureAttribute.getTimestampCanonicalizationMethod());
            timestampToken.setTimestampIncludes(signatureAttribute.getTimestampIncludedReferences());
            if (TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timestampType)) {
                this.addReferences(timestampToken.getTimestampedReferences(), this.getIndividualDataContentTimestampReferences(signatureAttribute.getTimestampIncludedReferences()));
            }
            this.timestampAttributeMap.put(timestampToken, signatureAttribute);
            result.add(timestampToken);
        }
        return result;
    }

    private TimestampToken createTimestampToken(Element encapsulatedTimeStamp, TimestampType timestampType, List<TimestampedReference> references, XAdESAttribute signatureAttribute, Integer orderWithinAttribute) {
        try {
            String base64EncodedTimestamp = encapsulatedTimeStamp.getTextContent();
            byte[] binaries = Utils.fromBase64((String)base64EncodedTimestamp);
            SignatureTimestampIdentifierBuilder identifierBuilder = new SignatureTimestampIdentifierBuilder(binaries).setSignature(this.signature).setAttribute((SignatureAttribute)signatureAttribute).setOrderOfAttribute(this.getAttributeOrder(signatureAttribute)).setOrderWithinAttribute(orderWithinAttribute);
            return new TimestampToken(binaries, timestampType, references, (TimestampIdentifierBuilder)identifierBuilder);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to build timestamp token from binaries '{}'! Reason : {}", new Object[]{encapsulatedTimeStamp.getTextContent(), e.getMessage(), e});
            } else {
                LOG.warn("Unable to build timestamp token! Reason : {}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }
    }

    protected List<EvidenceRecord> makeEvidenceRecords(XAdESAttribute signatureAttribute, List<TimestampedReference> references) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    protected List<SignatureScope> getTimestampScopes(TimestampToken timestampToken) {
        XAdESTimestampScopeFinder timestampScopeFinder = new XAdESTimestampScopeFinder();
        timestampScopeFinder.setSignature(this.signature);
        return timestampScopeFinder.findTimestampScope(timestampToken);
    }

    private List<TimestampedReference> getIndividualDataContentTimestampReferences(List<TimestampInclude> timestampIncludes) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        List signatureScopes = ((XAdESSignature)this.signature).getSignatureScopes();
        if (Utils.isCollectionNotEmpty((Collection)signatureScopes)) {
            for (ReferenceValidation referenceValidation : ((XAdESSignature)this.signature).getReferenceValidations()) {
                XAdESReferenceValidation xadesReferenceValidation = (XAdESReferenceValidation)referenceValidation;
                if (!this.isContentTimestampedReference(xadesReferenceValidation, timestampIncludes)) continue;
                for (SignatureScope signatureScope : signatureScopes) {
                    if (!Utils.endsWithIgnoreCase((String)xadesReferenceValidation.getUri(), (String)signatureScope.getDocumentName())) continue;
                    result.add(signatureScope);
                }
            }
        }
        return this.getSignerDataTimestampedReferences(result);
    }

    private boolean isContentTimestampedReference(XAdESReferenceValidation xadesReferenceValidation, List<TimestampInclude> includes) {
        for (TimestampInclude timestampInclude : includes) {
            if (!xadesReferenceValidation.getId().equals(timestampInclude.getURI())) continue;
            return true;
        }
        return false;
    }

    protected TimestampToken makeTimestampToken(XAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        throw new UnsupportedOperationException("XAdESTimeStampType element can contain more than one timestamp");
    }

    protected List<TimestampedReference> getArchiveTimestampReferences(List<TimestampToken> previousTimestamps) {
        List timestampedReferences = super.getArchiveTimestampReferences(previousTimestamps);
        this.addReferences(timestampedReferences, this.getKeyInfoReferences());
        return timestampedReferences;
    }

    protected List<TimestampedReference> getSignatureTimestampReferences() {
        List timestampedReferences = super.getSignatureTimestampReferences();
        if (XAdESSignatureUtils.isKeyInfoCovered((XAdESSignature)this.signature)) {
            this.addReferences(timestampedReferences, this.getKeyInfoReferences());
        }
        return timestampedReferences;
    }

    protected List<CertificateRef> getCertificateRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> certRefs = new ArrayList<CertificateRef>();
        boolean certificateRefV1 = this.isCertificateRefV1(unsignedAttribute);
        NodeList certRefsNodeList = null;
        if (certificateRefV1) {
            String currentCertRefsCertChildrenPath = this.xadesPaths.getCurrentCertRefsCertChildren();
            if (Utils.isStringNotEmpty((String)currentCertRefsCertChildrenPath)) {
                certRefsNodeList = unsignedAttribute.getNodeList(currentCertRefsCertChildrenPath);
            }
        } else {
            String currentCertRefs141CertChildrenPath = this.xadesPaths.getCurrentCertRefs141CertChildren();
            if (Utils.isStringNotEmpty((String)currentCertRefs141CertChildrenPath)) {
                certRefsNodeList = unsignedAttribute.getNodeList(currentCertRefs141CertChildrenPath);
            }
        }
        if (certRefsNodeList != null) {
            for (int ii = 0; ii < certRefsNodeList.getLength(); ++ii) {
                Element certRefElement = (Element)certRefsNodeList.item(ii);
                CertificateRef certificateRef = certificateRefV1 ? XAdESCertificateRefExtractionUtils.createCertificateRefFromV1(certRefElement, this.xadesPaths) : XAdESCertificateRefExtractionUtils.createCertificateRefFromV2(certRefElement, this.xadesPaths);
                if (certificateRef == null) continue;
                certRefs.add(certificateRef);
            }
        }
        return certRefs;
    }

    private boolean isCertificateRefV1(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES132Element.COMPLETE_CERTIFICATE_REFS.isSameTagName(localName);
    }

    protected List<CRLRef> getCRLRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<CRLRef> crlRefs = new ArrayList<CRLRef>();
        NodeList nodeList = unsignedAttribute.getNodeList(this.xadesPaths.getCurrentCRLRefsChildren());
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element element = (Element)nodeList.item(ii);
            CRLRef crlRef = XAdESRevocationRefExtractionUtils.createCRLRef(this.xadesPaths, element);
            if (crlRef == null) continue;
            crlRefs.add(crlRef);
        }
        return crlRefs;
    }

    protected List<OCSPRef> getOCSPRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<OCSPRef> ocspRefs = new ArrayList<OCSPRef>();
        NodeList nodeList = unsignedAttribute.getNodeList(this.xadesPaths.getCurrentOCSPRefsChildren());
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element element = (Element)nodeList.item(ii);
            OCSPRef ocspRef = XAdESRevocationRefExtractionUtils.createOCSPRef(this.xadesPaths, element);
            if (ocspRef == null) continue;
            ocspRefs.add(ocspRef);
        }
        return ocspRefs;
    }

    protected List<Identifier> getEncapsulatedCertificateIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentCertificateValuesEncapsulatedCertificate() : this.xadesPaths.getCurrentEncapsulatedCertificate();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            try {
                Element element = (Element)encapsulatedNodes.item(ii);
                byte[] binaries = this.getEncapsulatedTokenBinaries(element);
                CertificateToken certificateToken = DSSUtils.loadCertificate((byte[])binaries);
                certificateIdentifiers.add((Identifier)certificateToken.getDSSId());
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated certificate : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return certificateIdentifiers;
    }

    protected List<CRLBinary> getEncapsulatedCRLIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<CRLBinary> crlIdentifiers = new ArrayList<CRLBinary>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentRevocationValuesEncapsulatedCRLValue() : this.xadesPaths.getCurrentEncapsulatedCRLValue();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            try {
                Element element = (Element)encapsulatedNodes.item(ii);
                byte[] binaries = this.getEncapsulatedTokenBinaries(element);
                crlIdentifiers.add(CRLUtils.buildCRLBinary((byte[])binaries));
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse CRL binaries : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return crlIdentifiers;
    }

    protected List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<OCSPResponseBinary> ocspIdentifiers = new ArrayList<OCSPResponseBinary>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentRevocationValuesEncapsulatedOCSPValue() : this.xadesPaths.getCurrentEncapsulatedOCSPValue();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            try {
                Element element = (Element)encapsulatedNodes.item(ii);
                byte[] binaries = this.getEncapsulatedTokenBinaries(element);
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPFromBinaries((byte[])binaries);
                ocspIdentifiers.add(OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp));
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse OCSP response binaries : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return ocspIdentifiers;
    }

    private byte[] getEncapsulatedTokenBinaries(Element encapsulatedElement) {
        String base64String;
        Node firstChild;
        if (encapsulatedElement.hasChildNodes() && 3 == (firstChild = encapsulatedElement.getFirstChild()).getNodeType() && Utils.isBase64Encoded((String)(base64String = firstChild.getTextContent()))) {
            return Utils.fromBase64((String)base64String);
        }
        throw new DSSException(String.format("Cannot create the token reference. The element with local name [%s] must contain an encapsulated base64 token value! The found value is not a text node!", encapsulatedElement.getLocalName()));
    }

    protected ArchiveTimestampType getArchiveTimestampType(XAdESAttribute unsignedAttribute) {
        if (XAdESNamespace.XADES_141.isSameUri(unsignedAttribute.getNamespace())) {
            return ArchiveTimestampType.XAdES_141;
        }
        return ArchiveTimestampType.XAdES;
    }

    protected List<AdvancedSignature> getCounterSignatures(XAdESAttribute unsignedAttribute) {
        XAdESSignature counterSignature = DSSXMLUtils.createCounterSignature(unsignedAttribute.getElement(), (XAdESSignature)this.signature);
        if (counterSignature != null) {
            return Collections.singletonList(counterSignature);
        }
        return Collections.emptyList();
    }
}

