/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xades.definition.XAdESPath;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XAdESRevocationRefExtractionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESRevocationRefExtractionUtils.class);

    private XAdESRevocationRefExtractionUtils() {
    }

    public static OCSPRef createOCSPRef(XAdESPath xadesPaths, Element ocspRefElement) {
        Digest digest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement((Node)ocspRefElement, (String)xadesPaths.getCurrentDigestAlgAndValue()));
        ResponderId responderId = XAdESRevocationRefExtractionUtils.getOCSPResponderId(xadesPaths, ocspRefElement);
        if (responderId == null) {
            LOG.warn("Skipped OCSPRef (missing OCSPIdentifier / ResponderID)");
            return null;
        }
        Date producedAtDate = XAdESRevocationRefExtractionUtils.getOCSPProducedAtDate(xadesPaths, ocspRefElement);
        if (producedAtDate == null) {
            LOG.warn("Skipped OCSPRef (missing OCSPIdentifier / ProducedAt)");
            return null;
        }
        return new OCSPRef(digest, producedAtDate, responderId);
    }

    private static Date getOCSPProducedAtDate(XAdESPath xadesPaths, Element ocspRefElement) {
        Date producedAtDate = null;
        Element producedAtEl = DomUtils.getElement((Node)ocspRefElement, (String)xadesPaths.getCurrentOCSPRefProducedAt());
        if (producedAtEl != null) {
            producedAtDate = DomUtils.getDate((String)producedAtEl.getTextContent());
        }
        return producedAtDate;
    }

    private static ResponderId getOCSPResponderId(XAdESPath xadesPaths, Element ocspRefElement) {
        X500Principal responderName = null;
        byte[] ski = null;
        String currentOCSPRefResponderIDByName = xadesPaths.getCurrentOCSPRefResponderIDByName();
        String currentOCSPRefResponderIDByKey = xadesPaths.getCurrentOCSPRefResponderIDByKey();
        if (currentOCSPRefResponderIDByName != null && currentOCSPRefResponderIDByKey != null) {
            Element responderIdByKey;
            Element responderIdByName = DomUtils.getElement((Node)ocspRefElement, (String)currentOCSPRefResponderIDByName);
            if (responderIdByName != null) {
                responderName = DSSUtils.getX500PrincipalOrNull((String)responderIdByName.getTextContent());
            }
            if ((responderIdByKey = DomUtils.getElement((Node)ocspRefElement, (String)currentOCSPRefResponderIDByKey)) != null) {
                String base64EncodedResponderId = responderIdByKey.getTextContent();
                if (Utils.isBase64Encoded((String)base64EncodedResponderId)) {
                    ski = Utils.fromBase64((String)base64EncodedResponderId);
                } else {
                    LOG.warn("OCSP ResponderId value is not represented by a base64-encoded string!");
                }
            }
        } else {
            Element responderIdElement = DomUtils.getElement((Node)ocspRefElement, (String)xadesPaths.getCurrentOCSPRefResponderID());
            if (responderIdElement != null) {
                responderName = DSSUtils.getX500PrincipalOrNull((String)responderIdElement.getTextContent());
            }
        }
        if (responderName != null || Utils.isArrayNotEmpty(ski)) {
            return new ResponderId(responderName, ski);
        }
        return null;
    }

    public static CRLRef createCRLRef(XAdESPath xadesPaths, Element crlRefElement) {
        Digest digest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement((Node)crlRefElement, (String)xadesPaths.getCurrentDigestAlgAndValue()));
        if (digest == null) {
            LOG.warn("Skipped CRLRef (missing DigestAlgAndValue)");
            return null;
        }
        return new CRLRef(digest);
    }
}

