/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.DetachedSignatureResolver;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xmldsig.definition.XMLDSigAttribute;
import eu.europa.esig.xmldsig.definition.XMLDSigPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestValidator.class);
    private final Manifest manifest;

    public ManifestValidator(Element manifestElement, List<DSSDocument> detachedContents) {
        this(ManifestValidator.initManifest(manifestElement), detachedContents);
    }

    public ManifestValidator(Manifest manifest, List<DSSDocument> detachedContents) {
        this(manifest);
        ManifestValidator.initDetachedSignatureResolvers(manifest, detachedContents);
    }

    public ManifestValidator(Manifest manifest) {
        this.manifest = manifest;
    }

    private static Manifest initManifest(Element manifestElement) {
        try {
            return DSSXMLUtils.initManifest(manifestElement);
        }
        catch (XMLSecurityException e) {
            throw new DSSException(String.format("Unable to instantiate a ManifestValidator. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private static void initDetachedSignatureResolvers(Manifest manifest, List<DSSDocument> detachedContents) {
        List<DigestAlgorithm> usedReferenceDigestAlgos = DSSXMLUtils.getReferenceDigestAlgos(manifest.getElement());
        for (DigestAlgorithm digestAlgorithm : usedReferenceDigestAlgos) {
            manifest.addResourceResolver((ResourceResolverSpi)new DetachedSignatureResolver(detachedContents, digestAlgorithm));
        }
    }

    public List<ReferenceValidation> validate() {
        LOG.info("Validation of the manifest references ...");
        List<Reference> references = DSSXMLUtils.extractReferences(this.manifest);
        if (Utils.isCollectionEmpty(references)) {
            LOG.warn("No references found inside the ds:Manifest element!");
            return Collections.emptyList();
        }
        ArrayList<ReferenceValidation> referenceValidations = new ArrayList<ReferenceValidation>();
        for (Reference reference : references) {
            try {
                XAdESReferenceValidation refValidation = this.createReferenceValidation(reference);
                boolean refFound = DSSXMLUtils.isAbleToDeReferenceContent(reference);
                refValidation.setFound(refFound);
                boolean isDuplicated = DSSXMLUtils.isReferencedContentAmbiguous(this.manifest.getDocument(), refValidation.getUri());
                refValidation.setDuplicated(isDuplicated);
                if (refFound && !isDuplicated) {
                    refValidation.setIntact(reference.verify());
                }
                referenceValidations.add(refValidation);
            }
            catch (Exception e) {
                LOG.warn("Unable to verify reference with Id [{}] : {}", new Object[]{reference.getId(), e.getMessage(), e});
            }
        }
        return referenceValidations;
    }

    private XAdESReferenceValidation createReferenceValidation(Reference reference) {
        XAdESReferenceValidation refValidation = new XAdESReferenceValidation(reference);
        refValidation.setType(DigestMatcherType.MANIFEST_ENTRY);
        refValidation.setDigest(DSSXMLUtils.getReferenceDigest(reference));
        refValidation.setTransformationNames(this.getTransformNames(reference.getElement()));
        return refValidation;
    }

    private List<String> getTransformNames(Element refNode) {
        ArrayList<String> transformNames = new ArrayList<String>();
        NodeList nodeList = DomUtils.getNodeList((Node)refNode, (String)XMLDSigPath.TRANSFORMS_TRANSFORM_PATH);
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                Element transformElement = (Element)nodeList.item(ii);
                String algorithm = transformElement.getAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName());
                if (!Utils.isStringNotBlank((String)algorithm)) continue;
                transformNames.add(algorithm);
            }
        }
        return transformNames;
    }
}

