/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import eu.europa.esig.dss.xml.utils.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XPathPlacementSignatureBuilder
extends XAdESSignatureBuilder {
    protected XPathPlacementSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        super(params, document, certificateVerifier);
    }

    @Override
    protected Node getParentNodeOfSignature() {
        String xPathLocationString = this.params.getXPathLocationString();
        if (Utils.isStringNotEmpty((String)xPathLocationString)) {
            Element element = DomUtils.getElement((Node)this.documentDom, (String)xPathLocationString);
            if (element != null) {
                return element;
            }
            throw new IllegalArgumentException(String.format("Unable to find an element corresponding to XPath location '%s'", xPathLocationString));
        }
        return this.documentDom.getDocumentElement();
    }

    @Override
    protected void incorporateSignatureDom(Node parentNodeOfSignature) {
        if (this.params.getXPathElementPlacement() == null || Utils.isStringEmpty((String)this.params.getXPathLocationString())) {
            super.incorporateSignatureDom(parentNodeOfSignature);
            return;
        }
        switch (this.params.getXPathElementPlacement()) {
            case XPathAfter: {
                if (parentNodeOfSignature.isEqualNode(this.documentDom.getDocumentElement())) {
                    parentNodeOfSignature.appendChild(this.signatureDom);
                    break;
                }
                Node parent = parentNodeOfSignature.getParentNode();
                parent.insertBefore(this.signatureDom, parentNodeOfSignature.getNextSibling());
                break;
            }
            case XPathFirstChildOf: {
                parentNodeOfSignature.insertBefore(this.signatureDom, parentNodeOfSignature.getFirstChild());
                break;
            }
            default: {
                parentNodeOfSignature.appendChild(this.signatureDom);
            }
        }
    }
}

