/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.timestamp.TimestampAnalyzer;
import eu.europa.esig.dss.spi.validation.scope.DetachedTimestampScopeFinder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;

public class DetachedTimestampAnalyzer
extends DefaultDocumentAnalyzer
implements TimestampAnalyzer {
    protected TimestampType timestampType;
    protected TimestampToken timestampToken;

    DetachedTimestampAnalyzer() {
    }

    public DetachedTimestampAnalyzer(DSSDocument timestampFile) {
        this(timestampFile, TimestampType.CONTENT_TIMESTAMP);
    }

    public DetachedTimestampAnalyzer(DSSDocument timestampFile, TimestampType timestampType) {
        this.document = timestampFile;
        this.timestampType = timestampType;
    }

    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag((byte)firstByte)) {
            return DSSUtils.isTimestampToken((DSSDocument)dssDocument);
        }
        return false;
    }

    protected List<TimestampToken> buildDetachedTimestamps() {
        return Collections.singletonList(this.getTimestamp());
    }

    public TimestampToken getTimestamp() {
        if (this.timestampToken == null) {
            this.timestampToken = this.createTimestampToken();
            List<SignatureScope> timestampScopes = this.getTimestampScopes(this.timestampToken);
            this.timestampToken.setTimestampScopes(this.getTimestampScopes(this.timestampToken));
            this.timestampToken.getTimestampedReferences().addAll(this.getTimestampedReferences(timestampScopes));
            this.appendExternalEvidenceRecords(this.timestampToken);
        }
        return this.timestampToken;
    }

    protected TimestampToken createTimestampToken() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "The timestampFile must be defined!");
        Objects.requireNonNull(this.timestampType, "The TimestampType must be defined!");
        try {
            TimestampToken newTimestampToken = new TimestampToken(DSSUtils.toByteArray((DSSDocument)this.document), this.timestampType);
            newTimestampToken.setFilename(this.document.getName());
            newTimestampToken.matchData(this.getTimestampedData());
            return newTimestampToken;
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException(String.format("Unable to create a TimestampToken. Reason : %s", e.getMessage()), e);
        }
    }

    public void setTimestampedData(DSSDocument document) {
        Objects.requireNonNull(document, "The document is null");
        this.setDetachedContents(Arrays.asList(document));
    }

    public DSSDocument getTimestampedData() {
        int size = Utils.collectionSize((Collection)this.detachedContents);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new IllegalArgumentException("Only one detached document shall be provided for a timestamp validation!");
        }
        return (DSSDocument)this.detachedContents.iterator().next();
    }

    protected List<SignatureScope> getTimestampScopes(TimestampToken timestampToken) {
        DetachedTimestampScopeFinder timestampScopeFinder = new DetachedTimestampScopeFinder();
        timestampScopeFinder.setTimestampedData(this.getTimestampedData());
        return timestampScopeFinder.findTimestampScope(timestampToken);
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        throw new UnsupportedOperationException();
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        throw new UnsupportedOperationException("getOriginalDocuments(AdvancedSignature) is not supported for DetachedTimestampValidator!");
    }
}

