/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class PastCertificateValidationAcceptableCheck
extends ChainItem<XmlPSV> {
    private final XmlPCV pcv;
    private final Indication currentIndication;
    private final SubIndication currentSubIndication;

    public PastCertificateValidationAcceptableCheck(I18nProvider i18nProvider, XmlPSV result, XmlPCV pcv, String tokenId, Indication currentIndication, SubIndication currentSubIndication, LevelRule constraint) {
        super(i18nProvider, result, constraint, tokenId);
        this.pcv = pcv;
        this.currentIndication = currentIndication;
        this.currentSubIndication = currentSubIndication;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.PCV;
    }

    @Override
    protected boolean process() {
        if (this.pcv != null && this.pcv.getConclusion() != null) {
            Indication pcvIndication = this.pcv.getConclusion().getIndication();
            SubIndication pcvSubIndication = this.pcv.getConclusion().getSubIndication();
            return Indication.PASSED.equals((Object)pcvIndication) || Indication.INDETERMINATE.equals((Object)pcvIndication) && (SubIndication.REVOKED_NO_POE.equals((Object)pcvSubIndication) || SubIndication.REVOKED_CA_NO_POE.equals((Object)pcvSubIndication) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)pcvSubIndication) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)pcvSubIndication));
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_IPCVA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_IPCVA_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.currentIndication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.currentSubIndication;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.pcv != null && this.pcv.getControlTime() != null) {
            return this.i18nProvider.getMessage(MessageTag.CONTROL_TIME_ALONE, new Object[]{ValidationProcessUtils.getFormattedDate(this.pcv.getControlTime())});
        }
        return super.buildAdditionalInfo();
    }
}

