/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.timestamp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualificationAtTime;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.GrantedStatusCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.RelatedToMraEnactedTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.timestamp.checks.GrantedStatusAtTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.timestamp.checks.QTSTCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServicesFilterFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimestampQualificationAtTimeBlock
extends Chain<XmlValidationTimestampQualificationAtTime> {
    private final ValidationTime validationTime;
    private final Date date;
    private final List<TrustServiceWrapper> acceptableServices;
    private TimestampQualification tstQualif = TimestampQualification.NA;

    public TimestampQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, TimestampWrapper timestamp, List<TrustServiceWrapper> acceptableServices) {
        this(i18nProvider, validationTime, null, timestamp, acceptableServices);
    }

    public TimestampQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, Date date, TimestampWrapper timestamp, List<TrustServiceWrapper> acceptableServices) {
        super(i18nProvider, new XmlValidationTimestampQualificationAtTime());
        this.validationTime = validationTime;
        this.acceptableServices = acceptableServices;
        switch (validationTime) {
            case TIMESTAMP_GENERATION_TIME: {
                this.date = timestamp.getProductionTime();
                break;
            }
            case TIMESTAMP_POE_TIME: {
                this.date = date;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported time-stamp qualification time : " + validationTime);
            }
        }
    }

    @Override
    protected String buildChainTitle() {
        MessageTag message = MessageTag.TST_QUALIFICATION_AT_TIME;
        MessageTag param = ValidationProcessUtils.getValidationTimeMessageTag(this.validationTime);
        return this.i18nProvider.getMessage(message, new Object[]{param});
    }

    @Override
    protected void initChain() {
        TrustServiceFilter filter;
        List<TrustServiceWrapper> filteredServices = new ArrayList<TrustServiceWrapper>(this.acceptableServices);
        ChainItem<XmlValidationTimestampQualificationAtTime> item = null;
        if (this.isMRAEnactedForTrustedList(filteredServices)) {
            filter = TrustServicesFilterFactory.createMRAEnactedFilter();
            filteredServices = filter.filter(filteredServices);
            filter = TrustServicesFilterFactory.createFilterByMRAEquivalenceStartingDate(this.date);
            filteredServices = filter.filter(filteredServices);
            this.firstItem = this.hasMraEnactedTrustService(filteredServices);
            item = this.firstItem;
        }
        filter = TrustServicesFilterFactory.createFilterByQTST();
        List<TrustServiceWrapper> qtstServices = filter.filter(filteredServices);
        if (item == null) {
            this.firstItem = this.hasQTST(qtstServices);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.hasQTST(qtstServices));
        }
        filter = TrustServicesFilterFactory.createFilterByGranted();
        List<TrustServiceWrapper> grantedServices = filter.filter(qtstServices);
        item = item.setNextItem(this.hasGrantedStatus(grantedServices));
        filter = TrustServicesFilterFactory.createFilterByDate(this.date);
        List<TrustServiceWrapper> grantedAtDateServices = filter.filter(grantedServices);
        item = item.setNextItem(this.hasGrantedStatusAtDate(grantedAtDateServices));
        this.tstQualif = Utils.isCollectionNotEmpty(grantedAtDateServices) ? TimestampQualification.QTSA : TimestampQualification.TSA;
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlValidationTimestampQualificationAtTime)this.result).setTimestampQualification(this.tstQualif);
        ((XmlValidationTimestampQualificationAtTime)this.result).setValidationTime(this.validationTime);
        ((XmlValidationTimestampQualificationAtTime)this.result).setDateTime(this.date);
    }

    private ChainItem<XmlValidationTimestampQualificationAtTime> hasMraEnactedTrustService(List<TrustServiceWrapper> services) {
        return new RelatedToMraEnactedTrustServiceCheck<XmlValidationTimestampQualificationAtTime>(this.i18nProvider, (XmlValidationTimestampQualificationAtTime)this.result, services, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationTimestampQualificationAtTime> hasQTST(List<TrustServiceWrapper> services) {
        return new QTSTCheck<XmlValidationTimestampQualificationAtTime>(this.i18nProvider, (XmlValidationTimestampQualificationAtTime)this.result, services, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationTimestampQualificationAtTime> hasGrantedStatus(List<TrustServiceWrapper> services) {
        return new GrantedStatusCheck<XmlValidationTimestampQualificationAtTime>(this.i18nProvider, (XmlValidationTimestampQualificationAtTime)this.result, services, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationTimestampQualificationAtTime> hasGrantedStatusAtDate(List<TrustServiceWrapper> services) {
        return new GrantedStatusAtTimeCheck<XmlValidationTimestampQualificationAtTime>(this.i18nProvider, (XmlValidationTimestampQualificationAtTime)this.result, services, this.validationTime, this.getFailLevelRule());
    }

    private boolean isMRAEnactedForTrustedList(List<TrustServiceWrapper> trustServices) {
        for (TrustServiceWrapper trustService : trustServices) {
            if (!Utils.isTrue((Boolean)trustService.getTrustedList().isMra())) continue;
            return true;
        }
        return false;
    }
}

