/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.enumerations.QSCDStatus;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationCalculator;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CaQcCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateIssuedByConsistentByQCTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateIssuedByConsistentByQSCDTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateTypeCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateTypeCoverageCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.GrantedStatusCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsAbleToSelectOneTrustService;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsNoQualificationConflictDetectedCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.MRACertificateEquivalenceApplied;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QSCDCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QualifiedCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.RelatedToMraEnactedTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ServiceConsistencyCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustServiceAtTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustServicesByCertificateTypeCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustedCertificateMatchTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ValidCAQCCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServicesFilterFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertQualificationAtTimeBlock
extends Chain<XmlValidationCertificateQualification> {
    private final ValidationTime validationTime;
    private final Date date;
    private final CertificateWrapper signingCertificate;
    private final List<TrustServiceWrapper> acceptableServices;
    private CertificateQualification certificateQualification = CertificateQualification.NA;
    private List<TrustServiceWrapper> filteredServices;

    public CertQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, CertificateWrapper signingCertificate, List<TrustServiceWrapper> acceptableServices) {
        this(i18nProvider, validationTime, null, signingCertificate, acceptableServices);
    }

    public CertQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, Date date, CertificateWrapper signingCertificate, List<TrustServiceWrapper> acceptableServices) {
        super(i18nProvider, new XmlValidationCertificateQualification());
        ((XmlValidationCertificateQualification)this.result).setId(signingCertificate.getId());
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.acceptableServices = new ArrayList<TrustServiceWrapper>(acceptableServices);
        switch (validationTime) {
            case CERTIFICATE_ISSUANCE_TIME: {
                this.date = signingCertificate.getNotBefore();
                break;
            }
            case VALIDATION_TIME: 
            case BEST_SIGNATURE_TIME: {
                this.date = date;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown qualification time : " + validationTime);
            }
        }
    }

    @Override
    protected String buildChainTitle() {
        MessageTag message = MessageTag.CERT_QUALIFICATION_AT_TIME;
        MessageTag param = ValidationProcessUtils.getValidationTimeMessageTag(this.validationTime);
        return this.i18nProvider.getMessage(message, new Object[]{param});
    }

    @Override
    protected void initChain() {
        TrustServiceWrapper selectedTrustService;
        this.filteredServices = new ArrayList<TrustServiceWrapper>(this.acceptableServices);
        ChainItem<XmlValidationCertificateQualification> item = null;
        TrustServiceFilter filterByDate = TrustServicesFilterFactory.createFilterByDate(this.date);
        this.filteredServices = filterByDate.filter(this.filteredServices);
        if (this.isMRAEnactedForTrustedList(this.filteredServices)) {
            TrustServiceFilter filterByMRAEnacted = TrustServicesFilterFactory.createMRAEnactedFilter();
            this.filteredServices = filterByMRAEnacted.filter(this.filteredServices);
            filterByMRAEnacted = TrustServicesFilterFactory.createFilterByMRAEquivalenceStartingDate(this.date);
            this.filteredServices = filterByMRAEnacted.filter(this.filteredServices);
            this.firstItem = this.hasMraEnactedTrustService(this.filteredServices);
            item = this.firstItem;
            item = item.setNextItem(this.mraCertificateEquivalenceApplied());
        } else {
            item = this.firstItem = this.hasTrustServiceAtTime(this.filteredServices);
        }
        item = item.setNextItem(this.hasCaQc(this.filteredServices));
        TrustServiceFilter filterByCaQc = TrustServicesFilterFactory.createFilterByCaQc();
        List<TrustServiceWrapper> caqcServices = filterByCaQc.filter(this.filteredServices);
        if (Utils.isCollectionNotEmpty(caqcServices)) {
            this.filteredServices = caqcServices;
        }
        TrustServiceFilter filterByCertificateType = TrustServicesFilterFactory.createFilterByCertificateType(this.signingCertificate);
        this.filteredServices = filterByCertificateType.filter(this.filteredServices);
        item = item.setNextItem(this.hasTrustServiceWithType(this.filteredServices));
        for (TrustServiceWrapper trustServiceWrapper : this.filteredServices) {
            item = item.setNextItem(this.serviceConsistency(trustServiceWrapper));
        }
        if (this.filteredServices.size() > 1) {
            HashSet<CertificateQualification> results = new HashSet<CertificateQualification>();
            for (TrustServiceWrapper trustService : this.filteredServices) {
                CertificateQualificationCalculator calculator = new CertificateQualificationCalculator(this.signingCertificate, trustService);
                results.add(calculator.getQualification());
            }
            item = item.setNextItem(this.isNoConflictDetected(results));
            if (results.size() > 1) {
                this.certificateQualification = CertificateQualification.NA;
                return;
            }
        }
        TrustServiceFilter filterConsistentByStatus = TrustServicesFilterFactory.createConsistentServiceByStatusFilter();
        this.filteredServices = filterConsistentByStatus.filter(this.filteredServices);
        item = item.setNextItem(this.hasGrantedStatus(this.filteredServices));
        TrustServiceFilter trustServiceFilter = TrustServicesFilterFactory.createFilterByGranted();
        List<TrustServiceWrapper> grantedServices = trustServiceFilter.filter(this.filteredServices);
        if (Utils.isCollectionNotEmpty(grantedServices)) {
            this.filteredServices = grantedServices;
        }
        if (Utils.collectionSize(this.filteredServices) > 1) {
            TrustServiceFilter filterUnique = TrustServicesFilterFactory.createUniqueServiceFilter(this.signingCertificate);
            this.filteredServices = filterUnique.filter(this.filteredServices);
            item = item.setNextItem(this.isAbleToSelectOneTrustService(this.filteredServices));
        }
        TrustServiceWrapper trustServiceWrapper = selectedTrustService = !this.filteredServices.isEmpty() ? this.filteredServices.get(0) : null;
        if (selectedTrustService != null) {
            item = item.setNextItem(this.isTrustedCertificateMatchTrustService(selectedTrustService));
        }
        if (!caqcServices.contains(selectedTrustService) || !grantedServices.contains(selectedTrustService)) {
            this.filteredServices = Collections.emptyList();
            selectedTrustService = null;
        }
        item = item.setNextItem(this.isValidCAQC(selectedTrustService));
        TrustServiceFilter filterConsistentByQC = TrustServicesFilterFactory.createConsistentServiceByQCFilter();
        List<TrustServiceWrapper> trustServicesByQC = filterConsistentByQC.filter(this.filteredServices);
        item = item.setNextItem(this.hasConsistentByQCTrustService(trustServicesByQC));
        selectedTrustService = !trustServicesByQC.isEmpty() ? trustServicesByQC.get(0) : null;
        QualificationStrategy qcStrategy = QualificationStrategyFactory.createQualificationFromCertAndTL(this.signingCertificate, selectedTrustService);
        CertificateQualifiedStatus qualifiedStatus = qcStrategy.getQualifiedStatus();
        item = item.setNextItem(this.isQualified(qualifiedStatus));
        TrustServiceFilter filterConsistentByType = TrustServicesFilterFactory.createConsistentServiceByCertificateTypeFilter();
        List<TrustServiceWrapper> trustServicesByType = filterConsistentByType.filter(this.filteredServices);
        item = item.setNextItem(this.hasCertificateTypeCoverage(trustServicesByType));
        selectedTrustService = !trustServicesByType.isEmpty() ? trustServicesByType.get(0) : null;
        TypeStrategy typeStrategy = TypeStrategyFactory.createTypeFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        CertificateType type = typeStrategy.getType();
        item = item.setNextItem(this.certificateType(type));
        TrustServiceFilter filterConsistentByQSCD = TrustServicesFilterFactory.createConsistentServiceByQSCDFilter();
        List<TrustServiceWrapper> trustServicesByQSCD = filterConsistentByQSCD.filter(this.filteredServices);
        item = item.setNextItem(this.hasConsistentByQSCDTrustService(trustServicesByQSCD));
        selectedTrustService = !trustServicesByQSCD.isEmpty() ? trustServicesByQSCD.get(0) : null;
        QSCDStrategy qscdStrategy = QSCDStrategyFactory.createQSCDFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        QSCDStatus qscdStatus = qscdStrategy.getQSCDStatus();
        item = item.setNextItem(this.isQscd(qscdStatus));
        this.certificateQualification = CertQualificationMatrix.getCertQualification(qualifiedStatus, type, qscdStatus);
    }

    public List<TrustServiceWrapper> getFilteredServices() {
        if (this.filteredServices == null) {
            throw new IllegalStateException("execute() method shall be called first!");
        }
        return this.filteredServices;
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlValidationCertificateQualification)this.result).setCertificateQualification(this.certificateQualification);
        ((XmlValidationCertificateQualification)this.result).setValidationTime(this.validationTime);
        ((XmlValidationCertificateQualification)this.result).setDateTime(this.date);
    }

    private ChainItem<XmlValidationCertificateQualification> hasMraEnactedTrustService(List<TrustServiceWrapper> trustServices) {
        return new RelatedToMraEnactedTrustServiceCheck<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> mraCertificateEquivalenceApplied() {
        return new MRACertificateEquivalenceApplied<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, this.signingCertificate, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> hasCaQc(List<TrustServiceWrapper> trustServices) {
        return new CaQcCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> hasTrustServiceAtTime(List<TrustServiceWrapper> trustServices) {
        return new TrustServiceAtTimeCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.validationTime, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> hasTrustServiceWithType(List<TrustServiceWrapper> trustServices) {
        return new TrustServicesByCertificateTypeCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> isNoConflictDetected(Set<CertificateQualification> certificateQualificationsAtTime) {
        return new IsNoQualificationConflictDetectedCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, certificateQualificationsAtTime, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> hasGrantedStatus(List<TrustServiceWrapper> trustServices) {
        return new GrantedStatusCheck<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> hasCertificateTypeCoverage(List<TrustServiceWrapper> trustServices) {
        return new CertificateTypeCoverageCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> hasConsistentByQCTrustService(List<TrustServiceWrapper> trustServices) {
        return new CertificateIssuedByConsistentByQCTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> hasConsistentByQSCDTrustService(List<TrustServiceWrapper> trustServices) {
        return new CertificateIssuedByConsistentByQSCDTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> isAbleToSelectOneTrustService(List<TrustServiceWrapper> trustServices) {
        return new IsAbleToSelectOneTrustService(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> serviceConsistency(TrustServiceWrapper selectedTrustService) {
        return new ServiceConsistencyCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> isTrustedCertificateMatchTrustService(TrustServiceWrapper selectedTrustService) {
        return new TrustedCertificateMatchTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> isValidCAQC(TrustServiceWrapper selectedTrustService) {
        return new ValidCAQCCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> isQualified(CertificateQualifiedStatus qualifiedStatus) {
        return new QualifiedCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, qualifiedStatus, this.validationTime, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> certificateType(CertificateType type) {
        return new CertificateTypeCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, type, this.validationTime, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationCertificateQualification> isQscd(QSCDStatus qscdStatus) {
        return new QSCDCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, qscdStatus, this.validationTime, this.getWarnLevelRule());
    }

    private boolean isMRAEnactedForTrustedList(List<TrustServiceWrapper> trustServices) {
        for (TrustServiceWrapper trustService : trustServices) {
            if (!Utils.isTrue((Boolean)trustService.getTrustedList().isMra())) continue;
            return true;
        }
        return false;
    }
}

